/**********************************************************************************
 * ˵     ҵ߼
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using PlugNT.Common;
namespace PlugNT.Cms.Custom
{
    /// <summary>
    /// UserConfigļд
    /// </summary>
    public class XmlWriter_UserConfig
    {
        private static object lockHelper = new object();
        public static bool Update(List<NameValue> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + UserConfig.configfilename);
                        foreach (NameValue config in keyValueList)
                        {
                            XmlNode _xml_tmp = xmlDoc.SelectSingleNode(config.Name);
                            if (_xml_tmp != null)
                            {
                                _xml_tmp.InnerXml = config.Value;
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + UserConfig.configfilename);
                        UserConfig.InitConfig(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_UserConfig), ex);
                    return false;
                }
            }
            return true;
        }
        public static bool AppendFields(List<Model_UserField> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + UserConfig.configfilename);
                        XmlNode root = xmlDoc.SelectSingleNode("/configs/users/fields");
                        foreach (Model_UserField finfo in keyValueList)
                        {
                            XmlNode node = xmlDoc.SelectSingleNode("/configs/users/fields/item[@name='" + finfo.fieldName + "']");
                            if (node == null)
                            {
                                XmlElement xe1 = xmlDoc.CreateElement("item");   
                                xe1.SetAttribute("name", finfo.fieldName);
                                xe1.SetAttribute("type", finfo.fieldType);
                                xe1.InnerText = finfo.fieldTrueName;
                                
                                root.AppendChild(xe1);
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + UserConfig.configfilename);
                        UserConfig.InitFields(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_UserConfig), ex);
                    return false;
                }
            }
            return true;
        }
        public static bool UpdateFields(List<Model_UserField> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + UserConfig.configfilename);
                        foreach (Model_UserField finfo in keyValueList)
                        {
                            XmlNode node = xmlDoc.SelectSingleNode("/users/fields/item[@name='" + finfo.fieldName + "']");
                            if (node != null)
                            {
                                XmlElement xe1 = (XmlElement)node;   
                                xe1.SetAttribute("type", finfo.fieldType);
                                xe1.InnerText = finfo.fieldTrueName;
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + UserConfig.configfilename);
                        UserConfig.InitFields(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_UserConfig), ex);
                    return false;
                }
            }
            return true;
        }
      
        public static bool DeleteFields(List<string> keyList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + UserConfig.configfilename);
                        XmlNode root = xmlDoc.SelectSingleNode("/users/fields");
                        foreach (string fieldName in keyList)
                        {
                            XmlNode node = xmlDoc.SelectSingleNode("/users/fields/item[@name='" + fieldName + "']");
                            if (node != null)
                            {
                                root.RemoveChild(node);
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + UserConfig.configfilename);
                        UserConfig.InitFields(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_UserConfig), ex);
                    return false;
                }
            }
            return true;
        }
    }
    /// <summary>
    /// SiteConfigļд
    /// </summary>
    public class XmlWriter_SiteConfig
    {
        private static object lockHelper = new object();
        public static bool Update(List<NameValue> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + SiteConfig.configfilename);
                        foreach (NameValue config in keyValueList)
                        {
                            XmlNode _xml_tmp = xmlDoc.SelectSingleNode(config.Name);
                            if (_xml_tmp != null)
                            {
                                _xml_tmp.InnerXml = config.Value;
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + SiteConfig.configfilename);
                        SiteConfig.InitConfig(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_SiteConfig), ex);
                    return false;
                }
            }
            return true;
        }
    }
    /// <summary>
    /// PluginConfigļд
    /// </summary>
    public class XmlWriter_PluginConfig
    {
        private static object lockHelper = new object();
        public static bool Update(List<NameValue> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + PluginConfig.configfilename);
                        foreach (NameValue config in keyValueList)
                        {
                            XmlNode _xml_tmp = xmlDoc.SelectSingleNode(config.Name);
                            if (_xml_tmp != null)
                            {
                                _xml_tmp.InnerXml = config.Value;
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + PluginConfig.configfilename);
                        PluginConfig.InitPlugins(xmlDoc);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_PluginConfig), ex);
                    return false;
                }
            }
            return true;
        }
    }
    /// <summary>
    /// URLRewriteļд
    /// </summary>
    public class XmlWriter_ReurlConfig
    {
        private static object lockHelper = new object();
        public static bool Update(List<NameValue> keyValueList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (keyValueList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        foreach (NameValue config in keyValueList)
                        {
                            XmlNode _xml_tmp = xmlDoc.SelectSingleNode(config.Name);
                            if (_xml_tmp != null)
                            {
                                _xml_tmp.InnerXml = config.Value;
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_ReurlConfig), ex);
                    return false;
                }
            }
            return true;
        }
        public static bool AppendUrls(List<Model_URLRewrite> urlList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (urlList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        XmlNode root = xmlDoc.SelectSingleNode("/reurl/urls");
                        foreach (Model_URLRewrite url in urlList)
                        {
                            XmlNode urlNode = xmlDoc.SelectSingleNode("/reurl/urls/rewrite[@name='" + url.Name + "']");
                            if (urlNode != null)
                            {
                                urlNode.Attributes["name"].Value = url.Name;
                                urlNode.Attributes["pattern"].Value = url.Pattern;
                                urlNode.Attributes["page"].Value = url.Page;
                                urlNode.Attributes["querystring"].Value = url.QueryString;
                                urlNode.Attributes["requestargs"].Value = url.RequestArgs.ToString().ToLower();
                                root.AppendChild(urlNode);
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_ReurlConfig), ex);
                    return false;
                }
            }
            return true;
        }
        public static bool UpdateUrls(List<Model_URLRewrite> urlList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (urlList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        foreach (Model_URLRewrite url in urlList)
                        {
                            XmlNode urlNode = xmlDoc.SelectSingleNode("/reurl/urls/rewrite[@name='" + url.Name + "']");
                            if (urlNode != null)
                            {
                                urlNode.Attributes["name"].Value = url.Name;
                                urlNode.Attributes["pattern"].Value = url.Pattern;
                                urlNode.Attributes["page"].Value = url.Page;
                                urlNode.Attributes["querystring"].Value = url.QueryString;
                                urlNode.Attributes["requestargs"].Value = url.RequestArgs.ToString().ToLower();
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_ReurlConfig), ex);
                    return false;
                }
            }
            return true;
        }
        public static bool DeleteUrls(List<string> urlList)
        {
            lock (lockHelper)
            {
                try
                {
                    if (urlList.Count > 0)
                    {
                        XmlDataDocument xmlDoc = new XmlDataDocument();
                        xmlDoc.Load(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        XmlNode root = xmlDoc.SelectSingleNode("/reurl/urls");
                        foreach (string name in urlList)
                        {
                            XmlNode urlNode = xmlDoc.SelectSingleNode("/reurl/urls/rewrite[@name='" + name + "']");
                            if (urlNode != null)
                            {
                                root.RemoveChild(urlNode);
                            }
                        }
                        xmlDoc.Save(SiteConfig.ConfigPath + Http.SiteUrls.configfilename);
                        xmlDoc = null;
                    }
                }
                catch (Exception ex)
                {
                    SysManager.LogErrorWriteln(typeof(XmlWriter_ReurlConfig), ex);
                    return false;
                }
            }
            return true;
        }
    }
}

