/**********************************************************************************
 * ˵     ҵ߼
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Text;
namespace PlugNT.Cms.Custom
{
    /// <summary>
    /// Sql(accesssql server)
    /// </summary>
    public class SqlHelper
    {
        /// <summary>
        /// Σյsqlֶ(ذ)
        /// </summary>
        /// <param name="strField">sqlֶ</param>
        /// <returns></returns>
        public static string FieldFilter(string strField)
        {
            if (strField == null || strField.Trim() == "")
            {
                return "''";
            }
            else
            {
                return string.Concat("'", strField.Replace("'", "''"), "'");
            }
        }
        /// <summary>
        /// Σյsqlַ
        /// </summary>
        /// <param name="str">sqlַ</param>
        /// <returns></returns>
        public static string StrFilter(string str)
        {
            if (str == null || str.Trim() == "")
            {
                return "";
            }
            else
            {
                return str.Replace("'", "''");
            }
        }
        /// <summary>
        /// ˫TOPַɷҳSQL֧MSSQLACCESS
        /// </summary>
        /// <param name="pageSize">ÿҳ¼</param>
        /// <param name="currPageCount">ǰҳ</param>
        /// <param name="recordCount">¼</param>
        /// <param name="strSql">SQLѯ</param>
        /// <param name="orderFields">ֶΣá,id asc,addtime desc</param>
        /// <returns>ҳSQL</returns>
        public static string GetPagingString(int pageSize, int currPageCount, int recordCount, string strSql, string orderFields)
        {
            if (strSql == null || orderFields.Trim() == "")
            {
                throw new Exception("ֶβΪգ");
            }
            string[] arrStrOrders = orderFields.Split(',');
            StringBuilder sbOriginalOrder = new StringBuilder(); 
            StringBuilder sbReverseOrder = new StringBuilder(); 
            for (int i = 0; i < arrStrOrders.Length; i++)
            {
                arrStrOrders[i] = arrStrOrders[i].Trim();  
                if (i != 0)
                {
                    sbOriginalOrder.Append(", ");
                    sbReverseOrder.Append(", ");
                }
                sbOriginalOrder.Append(arrStrOrders[i]);
                int index = arrStrOrders[i].IndexOf(" "); //жǷʶ
                if (index > 0)
                {
                    bool flag = arrStrOrders[i].IndexOf(" desc", StringComparison.OrdinalIgnoreCase) != -1;
                    sbReverseOrder.AppendFormat("{0} {1}", arrStrOrders[i].Remove(index), flag ? "asc" : "desc");
                }
                else
                {
                    sbReverseOrder.AppendFormat("{0} desc", arrStrOrders[i]);
                }
            }
            pageSize = pageSize == 0 ? recordCount : pageSize;
            int pageCount = (recordCount + pageSize - 1) / pageSize;
            if (currPageCount < 1)
            {
                currPageCount = 1;
            }
            else if (currPageCount > pageCount)
            {
                currPageCount = pageCount;
            }
            StringBuilder sbSql = new StringBuilder();
            if (currPageCount == 1)
            {
                sbSql.AppendFormat(" select top {0} * ", pageSize);
                sbSql.AppendFormat(" from ({0}) as t ", strSql);
                sbSql.AppendFormat(" order by {0} ", sbOriginalOrder.ToString());
            }
            else if (currPageCount == pageCount)
            {
                sbSql.Append(" select * from ");
                sbSql.Append(" ( ");
                sbSql.AppendFormat(" select top {0} * ", recordCount - pageSize * (currPageCount - 1));
                sbSql.AppendFormat(" from ({0}) as t ", strSql);
                sbSql.AppendFormat(" order by {0} ", sbReverseOrder.ToString());
                sbSql.Append(" ) as t ");
                sbSql.AppendFormat(" order by {0} ", sbOriginalOrder.ToString());
            }
            else if (currPageCount <= (pageCount / 2 + pageCount % 2) + 1)
            {
                sbSql.Append(" select * from ");
                sbSql.Append(" ( ");
                sbSql.AppendFormat(" select top {0} * from ", pageSize);
                sbSql.Append(" ( ");
                sbSql.AppendFormat(" select top {0} * ", pageSize * currPageCount);
                sbSql.AppendFormat(" from ({0}) as t ", strSql);
                sbSql.AppendFormat(" order by {0} ", sbOriginalOrder.ToString());
                sbSql.Append(" ) as t ");
                sbSql.AppendFormat(" order by {0} ", sbReverseOrder.ToString());
                sbSql.Append(" ) as t ");
                sbSql.AppendFormat(" order by {0} ", sbOriginalOrder.ToString());
            }
            else
            {
                sbSql.AppendFormat(" select top {0} * from ", pageSize);
                sbSql.Append(" ( ");
                sbSql.AppendFormat(" select top {0} * ", ((recordCount % pageSize) + pageSize * (pageCount - currPageCount) + 1));
                sbSql.AppendFormat(" from ({0}) as t ", strSql);
                sbSql.AppendFormat(" order by {0} ", sbReverseOrder.ToString());
                sbSql.Append(" ) as t ");
                sbSql.AppendFormat(" order by {0} ", sbOriginalOrder.ToString());
            }
            return sbSql.ToString();
        }
        /// <summary>
        /// Join(strSql,"as a","a.*,b.field","left join tab as b on a.uid=b.id")
        /// </summary>
        /// <param name="strSql">sql</param>
        /// <param name="asTableName"></param>
        /// <param name="colNames"></param>
        /// <param name="onJoinAndWhere"></param>
        /// <returns></returns>
        public static string Join(string strSql, string asTableName, string colNames, string onJoinAndWhere)
        {
            if (asTableName == "" || colNames == "" || onJoinAndWhere == "")
            {
                return strSql;
            }
            return "select  " + colNames + " from(" + strSql + ")" + asTableName + " " + onJoinAndWhere;
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="orderBy"></param>
        /// <param name="asTableName"></param>
        /// <returns></returns>
        public static string GetJoinOrderBy(string orderBy, string asTableName)
        {
            int asIndex = asTableName.IndexOf(" ");
            if (asIndex > 0)
            {
                asTableName = asTableName.Substring(asIndex);
            }
            StringBuilder sbOrderBy = new StringBuilder();
            string[] arrOrder = orderBy.Split(',');
            if (arrOrder.Length > 0)
            {
                bool first = true;
                foreach (string by in arrOrder)
                {
                    if (!first)
                    {
                        sbOrderBy.Append(",");
                    }
                    else
                    {
                        first = false;
                    }
                    sbOrderBy.AppendFormat(asTableName + ".{0}", by.Trim());
                }
            }
            else
            {
                sbOrderBy.AppendFormat(asTableName + ".{0}", orderBy);
            }
            return " order by " + sbOrderBy.ToString();
        }
        /// <summary>
        /// ȡ¼SQL
        /// </summary>
        /// <param name="topCount">޶¼</param>
        /// <param name="strSql">SQLѯ</param>
        /// <returns>¼SQL</returns>
        public static string GetTopString(int topCount, string strSql)
        {
            return string.Format(" select top {0} * from ({1}) as t ", topCount, strSql);
        }
        /// <summary>
        /// ȡ¼SQL
        /// </summary>
        /// <param name="strSql">SQLѯ</param>
        /// <returns>¼SQL</returns>
        public static string GetCountString(string strSql)
        {
            return string.Format(" select count(1) as tcount from ({0}) as t ", strSql);
        }
    }
}

