/**********************************************************************************
 * ˵     ҵ߼
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Text;
using System.Collections.Generic;
using System.IO;
using System.Xml;
using PlugNT.Common;
using PlugNT.Cms.Custom;
namespace PlugNT.Cms.Custom
{
    /// <summary>
    /// Ӧò
    /// </summary>
    public class PluginConfig
    {
        public const string configfilename = "plugin.config";
        private static Dictionary<string, Model_AppPlugin> _appDictionary = null;
        public static Dictionary<string, Model_AppPlugin> appList
        {
            get { return _appDictionary; }
        }
        static PluginConfig()
        {
            XmlDocument xml = new XmlDocument();
            xml.Load(SiteConfig.ConfigPath + configfilename);
            InitPlugins(xml);
            xml = null;
        }
        public static Model_AppPlugin GetModel_AppPlugin(string key)
        {
            Model_AppPlugin appModel = null;
            if (_appDictionary.TryGetValue(key, out appModel))
            {
                return appModel;
            }
            else
            {
                return null;
            }
        }
        internal static void InitPlugins(XmlDocument xml)
        {
            if (xml == null)
            {
                xml = new XmlDocument();
                xml.Load(SiteConfig.ConfigPath + configfilename);
            }
            _appDictionary = new Dictionary<string, Model_AppPlugin>();
            XmlNodeList controls = xml.SelectNodes("/configs/plugitem");
            foreach (XmlNode control in controls)
            {
                XmlNode assembly = control.SelectSingleNode("assembly");
                XmlNode plug = control.SelectSingleNode("plug");
                XmlNode indexpath = control.SelectSingleNode("indexpath");
                
                Model_AppPlugin app = new Model_AppPlugin();
                if (plug != null)
                {
                    app.name = plug.InnerText;
                    app.setuped = plug.Attributes["setuped"].Value.ToLower() == "true";
                    app.configFile = plug.Attributes["configfile"].Value.Trim();
                }
                app.assemblyName = control.Attributes["name"].Value;
                if (assembly != null)
                {
                    XmlNode leftmenu = assembly.SelectSingleNode("ucenter/leftmenu");
                    if (leftmenu != null)
                    {
                        app.ucLeftmenu = leftmenu.InnerText;
                    }
                }
                if (indexpath != null)
                {
                    app.indexPath = indexpath.InnerText;
                }
                _appDictionary.Add(app.assemblyName, app);
            }
        }
    }
}

