/**********************************************************************************
 * ˵     ҵ߼
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Web;
using System.Xml;
using System.Text;
namespace PlugNT.Cms.Custom.Http
{
    /// <summary>
    /// վαUrlϢ
    /// </summary>
    public class SiteUrls
    {
        private static object lockHelper = new object();
        private static volatile SiteUrls instance = null;
        internal const string configfilename = "reurl.config";
        private bool _Enable;
        public bool Enable
        {
            get { return _Enable; }
        }
        private List<Model_URLRewrite> _Urls;
        public List<Model_URLRewrite> Urls
        {
            get { return _Urls; }
        }
        private SiteUrls()
        {
            _Urls = new List<Model_URLRewrite>();
            XmlDocument xml = new XmlDocument();
            xml.Load(SiteConfig.ConfigPath + configfilename);
            XmlNode tmpnode = xml.SelectSingleNode("reurl/enable");
            if (tmpnode != null)
            {
                _Enable = tmpnode.InnerXml.ToLower().Equals("true");
            }
            XmlNode root = xml.SelectSingleNode("reurl/urls");
            foreach (XmlNode n in root.ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment && n.Name.ToLower().Equals("rewrite"))
                {
                    XmlAttribute name = n.Attributes["name"];
                    XmlAttribute page = n.Attributes["page"];
                    XmlAttribute querystring = n.Attributes["querystring"];
                    XmlAttribute pattern = n.Attributes["pattern"];
                    XmlAttribute requestargs = n.Attributes["requestargs"];
                    if (name != null && page != null && querystring != null && pattern != null && requestargs != null)
                    {
                        _Urls.Add(new Model_URLRewrite(name.Value, pattern.Value, page.Value.Replace("^", "&"), querystring.Value.Replace("^", "&"), requestargs.Value.ToLower().Equals("true")));
                    }
                }
            }
        }
        public static void RemoveInstance()
        {
            if (instance != null)
            {
                instance = null;
            }
        }
        public static SiteUrls GetSiteUrls()
        {
            if (instance == null)
            {
                lock (lockHelper)
                {
                    if (instance == null)
                    {
                        instance = new SiteUrls();
                    }
                }
            }
            return instance;
        }
    }
}

