/**********************************************************************************
 * ˵     Urlд
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Web;
using System.Xml;
using System.Text;
using System.Text.RegularExpressions;
namespace PlugNT.Cms.Custom.Http
{
    /*
      reurl.configļ 
        <?xml version="1.0" encoding="utf-8" ?>
        <reurl>
          <enable>true</enable>
          <urls>
            <!--Ͳ-->
            <rewrite name="detail" pattern="/detail-(\d+).aspx" page="/detail.aspx" querystring="id=$1" requestargs="true" />
            <rewrite name="list" pattern="/list-(\d+).aspx" page="/list.aspx" querystring="page=$1" requestargs="true" />
            <rewrite name="attach" pattern="/tools/attach-(\d+).ashx" page="/tools/attach.ashx" querystring="id=$1" requestargs="true" />
            <!--ַͲ-->
            <!--bbs/index-{0}ͻ
            <rewrite name="default" path="/{0}-{1}.aspx" pattern="/(\w+)-(\w+).aspx" page="/default.aspx" querystring="m=$1^p=$2" requestargs="true" />
            <rewrite name="comment" pattern="/comment-(\d+)-(\d+).aspx" page="/comment.aspx" querystring="aid=$1^page=$2" requestargs="true" />
            <!--̳-->
            <rewrite name="bbs-index" pattern="/bbs/index-(\d+).aspx" page="/bbs/index.aspx" querystring="gid=$1" requestargs="true" />
            <rewrite name="bbs-forum" pattern="/bbs/forum-(\d+)-(\d+).aspx" page="/bbs/forum.aspx" querystring="cid=$1^page=$2" requestargs="true" />
            <rewrite name="bbs-thread" pattern="/bbs/thread-(\d+)-(\d+).aspx" page="/bbs/thread.aspx" querystring="fid=$1^page=$2" requestargs="true" />
          </urls>
        </reurl>
      http:
    */
    /*
    վĻᷢURLдпܻʧЧʧЧĻҪһIIS
    IISĿ¼--ӳ-롱ͨӦóӳ-
    ѡC:\WINDOWS\Microsoft.NET\Framework\v2.0.50727\aspnet_isapi.dllȻѹѡȥһҪȥȻȷ
    ֮󣬾Ϳˡ
    */
    /// <summary>
    /// һ²Ҫõ࣬ÿ󶼻ᴥApplication_BeginRequest¼һҳжʧ
    /// </summary>
    public class FileModule : IHttpModule
    {
        public static IBaseRewriter baseRewriter;
        public void Init(HttpApplication application)
        {
            application.BeginRequest += (new EventHandler(this.Application_BeginRequest));
            application.EndRequest += (new EventHandler(this.Application_EndRequest));
        }
        private void Application_BeginRequest(Object sender, EventArgs e)
        {
            HttpContext context = ((HttpApplication)sender).Context;
            if (baseRewriter != null)
            {
                baseRewriter.RewriterPath(context);
            }
            else
            {
                SiteUrls siteurls = SiteUrls.GetSiteUrls();
                if (siteurls.Enable)
                {
                    string requestPath = context.Request.Path.ToLower();
                    List<Model_URLRewrite> urls = siteurls.Urls;
                    foreach (Model_URLRewrite url in urls)
                    {
                        if (Regex.IsMatch(requestPath, url.Pattern, RegexOptions.IgnoreCase))
                        {
                            string qString = (url.RequestArgs) ? GetUrlPath(context.Request, url.QueryString) : url.QueryString;
                            string newUrl = Regex.Replace(requestPath, url.Pattern, qString, RegexOptions.IgnoreCase);
                            context.RewritePath("/" + url.Page, string.Empty, newUrl);
                            return;
                        }
                    }
                    context.RewritePath("/" + requestPath);
                }
            }
        }
        private string GetUrlPath(HttpRequest request, string fiterQueryString)
        {
            StringBuilder sb = new StringBuilder();
            fiterQueryString = fiterQueryString.Replace(" ", "").Trim();
            if (fiterQueryString == "")
            {
                foreach (string qstring in request.QueryString.AllKeys)
                {
                    sb.Append("&" + qstring + "=" + request.QueryString[qstring]);
                }
            }
            else
            {
                foreach (string qstring in request.QueryString.AllKeys)
                {
                    if (!("&" + fiterQueryString).Contains("&" + qstring + "="))
                    {
                        sb.Append("&" + qstring + "=" + request.QueryString[qstring]);
                    }
                }
            }
            return (fiterQueryString == "") ? sb.ToString().Trim('&') : fiterQueryString + sb.ToString();
        }
        private void Application_EndRequest(Object source, EventArgs e)
        {
        }
        public void Dispose()
        {
            
        }
    }
}

