using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using PlugNT.Cms.Custom;
using PlugNT.Common;
using PlugNT.Cms.Model;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Page;
using PlugNT.Cms.Utility;
namespace PlugNT.App.UCenter.Web
{
    /// <summary>
    /// Ajax첽ִࣨʹSessionʱҪ̳IRequiresSessionState
    /// </summary>
    public class Ajax : IHttpHandler, IRequiresSessionState
    {
        private string plugntCookieUcode = Key_Flags.CookieUserCode;
        private string userName = "";
        public void ProcessRequest(HttpContext context)
        {
            Uri uri_f = context.Request.UrlReferrer;
            if (uri_f == null)
            {
                uri_f = context.Request.Url;
            }
            if (uri_f != null)
            {
                string host = uri_f.Host.ToLower();
                if (host.StartsWith("localhost") || host.EndsWith(SiteConfig.DoMain))
                {
                    string arg = context.Request["a"] as string;
                    string responsestr = "{\"success\": false, \"error\": \"ʧܣ\"}"; ;
                    if (context.Session[Key_Flags.SessionUser] != null)
                    {
                        userName = context.Session[Key_Flags.SessionUser].ToString();
                    }
                    switch (arg)
                    {
                        ////û¼(Ҫ֤)
                        case "log_user":
                            responsestr = LoginUser(context);
                            break;
                        case "lou_user":
                            responsestr = LogoutUser(context);
                            break;
                        case "reg_user":
                            responsestr = RegisterUser(context);
                            break;
                        case "reg_oquth":
                            responsestr = RegisterOauth(context);
                            break;
                        case "che_username":
                            responsestr = ExistsUserName(context);
                            break;
                        case "che_imgcode":
                            responsestr = VerifyCode(context);
                            break;
                        case "set_mark":
                            responsestr = SetMark(context);
                            break;
                        case "set_avatar":
                            responsestr = SetAvatar(context);
                            break;
                        case "set_password":
                            responsestr = SetPassword(context);
                            break;
                        case "upt_user":
                            responsestr = UpdateUser(context);
                            break;
                        case "shw_message":
                            responsestr = ShowMessage(context);
                            break;
                        default:
                            break;
                    }
                    context.Response.Write(responsestr);
                }
                else
                {
                    context.Response.Write("{\"success\": false, \"error\": \"ʧܣǷ\"}");
                }
            }
            else
            {
                context.Response.Write("{\"success\": false, \"error\": \"ʧܣǷʣ\"}");
            }
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
        private string LoginUser(HttpContext context)
        {
            try
            {
                string restr = "null";
                string username = (context.Request["username"] == null) ? "" : context.Request["username"].Trim();
                string password = (context.Request["password"] == null) ? "" : context.Request["password"].Trim();
                string persistent = (context.Request["persistent"] == null) ? "" : context.Request["persistent"].Trim();
                string verifycode = (context.Request["verifycode"] == null) ? "" : context.Request["verifycode"].Trim();
                PlugNT.Pack.Imager.VerifyCoder coder = new PlugNT.Pack.Imager.VerifyCoder();
                coder.context = context;
                if (verifycode == "" || verifycode.ToLower() != coder.Get().ToLower())
                {
                    return "{\"success\": false, \"error\": \"֤Ϊ\"}";
                }
                IUser bllUser = new IUser();
                if (bllUser.Login(username, password, out restr))
                {
                    if (persistent == "true")
                    {
                        string eCode = PlugNT.Cms.Custom.SysManager.GetNoString();
                        bllUser.UpdatePassCode(username, eCode);
                        PlugNT.Common.Utils.SetCookie(plugntCookieUcode, username + "|" + eCode);
                    }
                    string ipcode = PlugNT.Common.Utils.GetRealIP().Trim();
                    bllUser.Logined(username, ipcode, "û첽½");
                    return "{\"success\": true, \"error\": \"" + restr + "\"}";
                }
                else
                {
                    return "{\"success\": false, \"error\": \"" + restr + "\"}";
                }
            }
            catch
            {
                return "{\"success\": false, \"error\": \"¼쳣\"}";
            }
        }
        private string LogoutUser(HttpContext context)
        {
            try
            {
                PlugNT.Common.Utils.SetCookie(plugntCookieUcode, "");
                new IUser().Logout();
                return "{\"success\": true, \"error\": \"null\"}";
            }
            catch
            {
                return "{\"success\": false, \"error\": \"ǳ쳣\"}"; ;
            }
        }
        private string ExistsUserName(HttpContext context)
        {
            try
            {
                string username = (context.Request["username"] == null) ? "" : context.Request["username"].Trim();
                if (!new IUser().Exists(username))
                {
                    return "{\"success\": false, \"error\": \"û" + username.Replace("\"", "") + "Ѵ\"}";
                }
                return "{\"success\": true, \"error\": \"null\"}";
            }
            catch
            {
                return "{\"success\": false, \"error\": \"쳣ϵԱ\"}"; ;
            }
        }
        private string RegisterUser(HttpContext context)
        {
            try
            {
                if (UserConfig.UsersRegister == 0)
                {
                    return "{\"success\": false, \"error\": \"עʧ,Աѽע!\"}";
                }
                string email = (context.Request["email"] == null) ? "" : context.Request["email"].Trim();
                string username = (context.Request["username"] == null) ? "" : context.Request["username"].Trim();
                string password = (context.Request["password"] == null) ? "" : context.Request["password"].Trim();
                string comfirmPassword = (context.Request["comfirmPassword"] == null) ? "" : context.Request["comfirmPassword"].Trim();
                string verifycode = (context.Request["verifycode"] == null) ? "" : context.Request["verifycode"].Trim();
                PlugNT.Pack.Imager.VerifyCoder coder = new PlugNT.Pack.Imager.VerifyCoder();
                coder.context = context;
                if (verifycode == "" || verifycode.ToLower() != coder.Get().ToLower())
                {
                    return "{\"success\": false, \"error\": \"֤Ϊ\"}";
                }
                if (email == "")
                {
                    return "{\"success\": false, \"error\": \"עʧ,䲻Ϊգ\"}";
                }
                string error;
                if (!CheckUsername(username, out error))
                {
                    return "{\"success\": false, \"error\": \"עʧ," + error + "\"}";
                }
                if (!(password == comfirmPassword))
                {
                    return "{\"success\": false, \"error\": \"עʧ,벻ȷ\"}";
                }
                IUser bllUser = new IUser();
                IUserInfo uinfo = new IUserInfo();
                uinfo.AddField(UserConfig.GetFieldName("username"), username);
                uinfo.AddField(UserConfig.GetFieldName("email"), email);
                uinfo.AddField(UserConfig.GetFieldName("password"), bllUser.Hasher(password));
                uinfo.AddField(UserConfig.GetFieldName("grade"), 3);
                if (UserConfig.UsersRegister == 2)
                {
                    string ecode = SysManager.GetNoString();
                    uinfo.AddField(UserConfig.GetFieldName("email_code"), ecode);
                }
                if (!bllUser.Add(uinfo))
                {
                    return "{\"success\": false, \"error\": \"עʧܣ˺ʧܣ\"}";
                }
                string sendError = "";
                if (UserConfig.UsersRegister == 2)
                {
                    EmailTempletInfo eInfo = new EmailTemplet().GetEmailTempletInfo(UcConfig.registerEmailTempletId);
                    if (eInfo != null)
                    {
                        string title = eInfo.title.Replace("{webname}", SiteConfig.SiteName);
                        string content = eInfo.content.Replace("{webname}", SiteConfig.SiteName);
                        content = content.Replace("{username}", uinfo.GetFieldToString("username"));
                        content = content.Replace("{linkurl}", SiteConfig.SiteUrl + "/ucenter/verify.aspx?email_code=" + uinfo.GetFieldToString("email_code"));
                        sendError = SendEmail(uinfo.GetFieldToString("email"), title, content);
                    }
                }
                if (sendError != "")
                {
                    return "{\"success\": false, \"error\": \"עɹʼʧ!\"}";
                }
                return "{\"success\": true, \"error\": \"null\"}";
            }
            catch (Exception ex)
            {
                SysManager.LogErrorWriteln(this.GetType(), ex);
                return "{\"success\": false, \"error\": \"ע쳣ϵԱ\"}"; ;
            }
        }
        private string RegisterOauth(HttpContext context)
        {
            try
            {
                if (UserConfig.UsersRegister == 0)
                {
                    return "{\"success\": false, \"error\": \"עʧ,Աѽע!\"}"; 
                }
                if (context.Session[Key_Flags.SessionOauth] == null)
                {
                    return "{\"success\": false, \"error\": \"½ʧ,ûͨữ½!\"}";
                }
                string username = (context.Request["username"] == null) ? "" : context.Request["username"].Trim();
                string password = (context.Request["password"] == null) ? "" : context.Request["password"].Trim();
                string binduser = (context.Request["binduser"] == null) ? "" : context.Request["binduser"].Trim();
                string oauthCode = context.Session[Key_Flags.SessionOauth].ToString();
                string loginedfrom = PlugNT.Common.Utils.GetParam(oauthCode, "loginedfrom");
                string uid = PlugNT.Common.Utils.GetParam(oauthCode, "uid");
                string pic = PlugNT.Common.Utils.GetParam(oauthCode, "pic");
                if (loginedfrom == "" || pic == "" || uid == "")
                {
                    return "{\"success\": false, \"error\": \"½ʧ,ữ½!\"}";
                }
                string error;
                if (!CheckUsername(username, out error))
                {
                    return "{\"success\": false, \"error\": \"עʧ,"+error+"\"}"; 
                }
                IUser bllUser = new IUser();
                if (binduser == "1")
                {
                    IUserInfo uinfo = new IUserInfo();
                    string[] arr = IUser.GetArray(UserConfig.GetFieldNameList("username", "password"), "and " + UserConfig.GetFieldName("username") + "=" + SqlHelper.FieldFilter(username));
                    if (arr == null || arr[0] != username || arr[1] != password)
                    {
                        return "{\"success\": false, \"error\": \"ʧ,˺Ųڻ!\"}";
                    }
                    uinfo.AddField(UserConfig.GetFieldName("loginedfrom"), loginedfrom);
                    uinfo.AddField(UserConfig.GetFieldName("enable"), 1);
                    uinfo.AddField(UserConfig.GetFieldName("isout"), 1);
                    if (bllUser.Update(username, uinfo))
                    {
                        string loginError = "";
                        if (bllUser.Login(username, password, out loginError))
                        {
                            string ipcode = PlugNT.Common.Utils.GetRealIP().Trim();
                            bllUser.Logined(username, ipcode, loginedfrom.Split('_')[0]+"½");
                            context.Session.Remove(Key_Flags.SessionOauth);
                            return "{\"success\": true, \"error\": \"null\"}";
                        }
                        else
                        {
                            return "{\"success\": false, \"error\": \"󶨳ɹ½ʧܣ" + loginError + "\"}";
                        }
                    }
                    else
                    {
                        return "{\"success\": false, \"error\": \"ʧܣ\"}";
                    }
                }
                else
                {
                    string lpassword = PlugNT.Cms.Custom.SysManager.GetNoString();
                    IUserInfo uinfo = new IUserInfo();
                    uinfo.AddField(UserConfig.GetFieldName("loginedfrom"), loginedfrom);
                    uinfo.AddField(UserConfig.GetFieldName("username"), uid);
                    uinfo.AddField(UserConfig.GetFieldName("password"), bllUser.Hasher(lpassword));
                    uinfo.AddField(UserConfig.GetFieldName("pic"), pic);
                    uinfo.AddField(UserConfig.GetFieldName("grade"), 3);
                    uinfo.AddField(UserConfig.GetFieldName("enable"), 1);
                    uinfo.AddField(UserConfig.GetFieldName("isout"), 1);
                    if (bllUser.Add(uinfo))
                    {
                        string loginError = "";
                        if (bllUser.Login(username, password, out loginError))
                        {
                            string ipcode = PlugNT.Common.Utils.GetRealIP().Trim();
                            bllUser.Logined(username, ipcode, loginedfrom.Split('_')[0] + "½");
                            context.Session.Remove(Key_Flags.SessionOauth);
                            return "{\"success\": true, \"error\": \"null\"}";
                        }
                        else
                        {
                            return "{\"success\": false, \"error\": \"עɹ½ʧܣ" + loginError + "\"}";
                        }
                    }
                    else
                    {
                        return "{\"success\": false, \"error\": \"עʧܣ˺Ѵڣ\"}";
                    }
                }
            }
            catch (Exception ex)
            {
                SysManager.LogErrorWriteln(this.GetType(), ex);
                return "{\"success\": false, \"error\": \"½쳣ϵԱ\"}"; ;
            }
        }
        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string VerifyCode(HttpContext context)
        {
            try
            {
                string restr = "null";
                string verifycode = (context.Request["verifyCode"] == null) ? "" : context.Request["verifyCode"].Trim();
                PlugNT.Pack.Imager.VerifyCoder coder = new PlugNT.Pack.Imager.VerifyCoder();
                coder.context = context;
                if (verifycode != "" && verifycode.ToLower() == coder.Get().ToLower())
                {
                    return "{\"success\": true, \"error\": \"" + restr + "\"}";
                }
                else
                {
                    return "{\"success\": false, \"error\": \"֤Ϊ\"}";
                }
            }
            catch
            {
                return "{\"success\": false, \"error\": \"Ajax쳣\"}";
            }
        }
        /// <summary>
        /// ͷ
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string SetAvatar(HttpContext context)
        {
            try
            {
                if (userName == "")
                {
                    return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
                }
                string filepath = "";
                string fileid = context.Request["fileid"] as string;
                HttpPostedFile postedFile = context.Request.Files[fileid];
                if (postedFile == null)
                {
                    return "{\"success\": false, \"error\": \"ϴͷʧܣûѡļ\", \"text\":\"null\"}";
                }
                string extname = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf("."));
                if (postedFile.ContentLength > 29760)
                {
                    return "{\"success\": false, \"error\": \"ϴͷʧܣϴͷܳ24KB\", \"text\":\"null\"}";
                }
                if (!SiteConfig.UploadFileType.ToLower().Contains("|" + extname.ToLower() + "|"))
                {
                    return "{\"success\": false, \"error\": \"͵ļϴ\", \"text\":\"null\"}";
                }
                string[] arr = IUser.GetArray(UserConfig.GetFieldNameList("id", "pic"), "and " + UserConfig.GetFieldName("username") + "=" + SqlHelper.FieldFilter(userName));
                if (arr == null)
                {
                    return "{\"success\": false, \"error\": \"ͷʧ,˺Ųڣ\"}";
                }
                System.IO.MemoryStream rs = PlugNT.Common.FileHelper.CopyStream(postedFile);
                if (!PlugNT.Common.FileHelper.IsSafeFile(rs, true))
                {
                    return "{\"success\": false, \"error\": \"ͷʧܣϴ͵ļ\", \"text\":\"null\"}";
                }
                
                string tpath = System.IO.Path.GetFileName(postedFile.FileName);
                string ipath = DateTime.Now.Year.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Day.ToString();
                string nfile = SysManager.GetNoString() + extname;
                string dpath = SiteConfig.RootPath + "\\" + SiteConfig.UploadFilePath + "\\" + ipath.Replace('/', '\\');
                string spath = dpath + "\\" + nfile;
                filepath = SiteConfig.UploadFilePath + "/" + ipath + "/" + nfile;
                IUser bllUser = new IUser();
                IUserInfo model = new IUserInfo();
                model.AddField(UserConfig.GetFieldName("pic"), filepath);
                if (bllUser.Update(int.Parse(arr[0]), model))
                {
                    if (arr[1] != "")
                    {
                        string oldFilePath = SiteConfig.RootPath + "\\" + arr[1].Trim('/').Replace('/', '\\');
                        if (System.IO.File.Exists(oldFilePath))
                        {
                            System.IO.File.Delete(oldFilePath);
                        }
                    }
                    if (!System.IO.Directory.Exists(dpath))
                    {
                        System.IO.Directory.CreateDirectory(dpath);
                    }
                    postedFile.SaveAs(spath);
                    return "{\"success\": true, \"error\": \"null\", \"text\":\"" + filepath + "\"}";
                }
                else
                {
                    return "{\"success\": false, \"error\": \"ͷʧܣ\"}";
                }
            }
            catch
            {
                return "{\"success\": false, \"error\": \"ͷ쳣\"}";
            }
        }
        
        /// <summary>
        /// ǩ
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string SetMark(HttpContext context)
        {
            if (userName == "")
            {
                return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
            }
            int userId = IUser.GetOnlineUserId(userName);
            if (userId == 0)
            {
                return "{\"success\": false, \"error\": \"˺Ųڻɾ\"}";
            }
            string mark = (context.Request["mark"] == null) ? "" : context.Request["mark"].Trim();
            if (mark == "")
            {
                return "{\"success\": false, \"error\": \"ǩʧܣǩΪգ\"}";
            }
            IUserInfo model = new IUserInfo();
            model.AddField(UserConfig.GetFieldName("mark"), mark.Replace("< ", "[").Replace(">", "]"));
            if (new IUser().Update(userId, model))
            {
                return "{\"success\": true, \"error\": \"null\"}";
            }
            else
            {
                return "{\"success\": false, \"error\": \"ǩʧܣ\"}";
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string SetPassword(HttpContext context)
        {
            if (userName == "")
            {
                return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
            }
            string password = (context.Request["password"] == null) ? "" : context.Request["password"].Trim();
            string newPassword = (context.Request["newPassword"] == null) ? "" : context.Request["newPassword"].Trim();
            string confirmPassword = (context.Request["confirmPassword"] == null) ? "" : context.Request["confirmPassword"].Trim();
            if (newPassword.Length > 20 || newPassword.Length < 6)
            {
                return "{\"success\": false, \"error\": \"޸ʧܣ볤Ҫ6-20֮䣡\"}";
            }
            if (newPassword != confirmPassword)
            {
                return "{\"success\": false, \"error\": \"޸ʧܣ벻һ\"}";
            }
            if (new IUser().ModifyPass(userName, password, newPassword))
            {
                return "{\"success\": true, \"error\": \"null\"}";
            }
            else
            {
                return "{\"success\": false, \"error\": \"޸ʧܣԭ\"}";
            }
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string UpdateUser(HttpContext context)
        {
            try
            {
                if (userName == "")
                {
                    return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
                }
                int userId = IUser.GetOnlineUserId(userName);
                if (userId == 0)
                {
                    return "{\"success\": false, \"error\": \"˺Ųڻɾ\"}";
                }
                IUserInfo model = new IUserInfo();
                string nickname = context.Request["nickname"];
                if (nickname != null)
                {
                    model.AddField(UserConfig.GetFieldName("nickname"), nickname.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string sex = context.Request["sex"];
                if (sex != null)
                {
                    model.AddField(UserConfig.GetFieldName("sex"), sex.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string birthday = context.Request["birthday"];
                if (birthday != null)
                {
                    if (PlugNT.Common.Utils.IsDateString(birthday))
                    {
                        model.AddField(UserConfig.GetFieldName("birthday"), birthday);
                    }
                }
                string tel = context.Request["tel"];
                if (tel != null)
                {
                    model.AddField(UserConfig.GetFieldName("tel"), tel.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string mobile = context.Request["mobile"];
                if (mobile != null)
                {
                    model.AddField(UserConfig.GetFieldName("mobile"), mobile.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string zipcode = context.Request["zipcode"];
                if (zipcode != null)
                {
                    model.AddField(UserConfig.GetFieldName("zipcode"), zipcode.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string address = context.Request["address"];
                if (address != null)
                {
                    model.AddField(UserConfig.GetFieldName("address"), address.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string order_contact = context.Request["order_contact"];
                if (order_contact != null)
                {
                    model.AddField(UserConfig.GetFieldName("order_contact"), order_contact.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string order_address = context.Request["order_address"];
                if (order_address != null)
                {
                    model.AddField(UserConfig.GetFieldName("order_address"), order_address.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string order_zipcode = context.Request["order_zipcode"];
                if (order_zipcode != null)
                {
                    model.AddField(UserConfig.GetFieldName("order_zipcode"), order_zipcode.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string order_mobile = context.Request["order_mobile"];
                if (order_mobile != null)
                {
                    model.AddField(UserConfig.GetFieldName("order_mobile"), order_mobile.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string order_tel = context.Request["order_tel"];
                if (order_tel != null)
                {
                    model.AddField(UserConfig.GetFieldName("order_tel"), order_tel.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                string mark = context.Request["mark"];
                if (mark != null)
                {
                    model.AddField(UserConfig.GetFieldName("mark"), mark.Trim().Replace("< ", "[").Replace(">", "]"));
                }
                if (new IUser().Update(userId, model))
                {
                    return "{\"success\": true, \"error\": \"null\"}";
                }
                else
                {
                    return "{\"success\": false, \"error\": \"޸ʧܣ\"}";
                }
            }
            catch(Exception ex)
            {
                SysManager.LogErrorWriteln(this.GetType(), ex);
                return "{\"success\": false, \"error\": \"޸쳣\"}";
            }
        }
        /// <summary>
        /// ʾ˼ҪϢ
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private string ShowMessage(HttpContext context)
        {
            if (userName == "")
            {
                return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
            }
            int userId = IUser.GetOnlineUserId(userName);
            if (userId == 0)
            {
                return "{\"success\": false, \"error\": \"˺Ųڻɾ\"}";
            }
            int type = (context.Request["type"] == null) ? 1 : (PlugNT.Common.Utils.IsNumeric(context.Request["type"].Trim()) ? int.Parse(context.Request["type"].Trim()) : 1);
            int currPageCount = (context.Request["page"] == null) ? 0 : (PlugNT.Common.Utils.IsNumeric(context.Request["page"].Trim()) ? int.Parse(context.Request["page"].Trim()) : 0);
            int pageSize = (context.Request["pagesize"] == null) ? 10 : (PlugNT.Common.Utils.IsNumeric(context.Request["pagesize"].Trim()) ? int.Parse(context.Request["pagesize"].Trim()) : 10);
            int recordCount = 0;
            DataTable dt = new PlugNT.App.UCenter.BLL.UMessage().GetUDataList(pageSize, currPageCount, userId, type, out recordCount);
            StringBuilder sb = new StringBuilder();
            foreach (DataRow dr in dt.Rows)
            {
                sb.Append("{\"id\":\"" + dr["id"].ToString() + "\",\"remark\":\"" + dr["remark"].ToString() + "\",\"create_time\":\"" + dr["create_time"].ToString() + "\"},");
            }
            return "{\"success\": true, \"count\":" + recordCount + ", \"list\": [" + sb.ToString().Trim(',') + "]}";
        }
        /// <summary>
        /// ʼ
        /// </summary>
        /// <param name="account"></param>
        /// <param name="title"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        private string SendEmail(string account, string title, string content)
        {
            try
            {
                return PlugNT.Common.Mail.Send(
                    SiteConfig.EmailsAccount,
                    SiteConfig.EmailsPassword,
                    SiteConfig.EmailsServiceaddress,
                    int.Parse(SiteConfig.EmailsServiceport),
                    true,
                    SiteConfig.EmailsEnablessl,
                    SiteConfig.EmailsBackaddress,
                    SiteConfig.EmailsNickname,
                    account,
                    title,
                    content
                );
            }
            catch
            {
                return "ʼ쳣,ô";
            }
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="username"></param>
        /// <param name="err"></param>
        /// <returns></returns>
        private bool CheckUsername(string username, out string err)
        {
            err = "";
            if (username.ToLower().StartsWith("vip"))
            {
                err = "ʹvipǰ׺";
                return false;
            }
            return true;
        }
        
    }
}

