using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using PlugNT.Common;
using PlugNT.Cms.Page;
using PlugNT.Cms.Custom;
using PlugNT.App.UCenter.Model;
using PlugNT.App.UCenter.BLL;
namespace PlugNT.App.UCenter.Web
{
    public partial class SetGrade : AdminPager
    {
        private UGrade bllUGrade = new UGrade();
        private string sid = "0";
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            string type = (Request.QueryString["t"] == null) ? "" : Request.QueryString["t"].Trim();
            sid = (Request.QueryString["id"] == null) ? "0" : Request.QueryString["id"].Trim();
            if (!IsPostBack)
            {
                switch (type)
                {
                    case "add":
                        btnUpdate.Text = "  ";
                        break;
                    case "edit":
                        btnUpdate.Text = " ޸ ";
                        break;
                    case "delete":
                        Delete();
                        break;
                    default:
                        ShowMessager("õȼʧܣȷ·ڣ", Type_Message.Error);
                        break;
                }
                InitData();
                hidAction.Value = type;
            }
        }
        private void InitData()
        {
            if (sid != "" && sid != "0")
            {
                UGradeInfo uInfo = bllUGrade.GetUGradeInfo(int.Parse(sid));
                if (uInfo != null)
                {
                    txtName.Text = uInfo.grade_name;
                    txtGrade.Text = uInfo.grade.ToString();
                }
            }
        }
        private void Delete()
        {
            this.CheckReadOnly();
            if (bllUGrade.Delete(int.Parse(sid)))
            {
                Response.Redirect("./GradeList.aspx" + GetBaseParams("?"));
            }
            else
            {
                ShowMessager("ȼʧ,õȼѾɾ", Type_Message.Error);
            }
        }
        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            this.CheckReadOnly();
            UGradeInfo uInfo = (sid != "" && sid != "0") ? bllUGrade.GetUGradeInfo(int.Parse(sid)) : new UGradeInfo();
            uInfo.grade_name = txtName.Text.Trim();
            uInfo.grade = int.Parse(txtGrade.Text.Trim());
            if (hidAction.Value == "add")
            {
                if (bllUGrade.Add(uInfo))
                {
                    Response.Redirect("./GradeList.aspx" + GetBaseParams("?"));
                }
                else
                {
                    ShowMessager("ӵȼʧܣ", Type_Message.Error);
                }
            }
            else
            {
                if (hidAction.Value == "edit")
                {
                    if (bllUGrade.Update(uInfo))
                    {
                        Response.Redirect("./GradeList.aspx" + GetBaseParams("?"));
                    }
                    else
                    {
                        ShowMessager("޸ĵȼʧܣ", Type_Message.Error);
                    }
                }
                else
                {
                    ShowMessager("޸ĵȼʧܣδ֪", Type_Message.Error);
                }
            }
        }
    }
}

