using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.IO;
using System.Xml;
using PlugNT.Common;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Model;
namespace PlugNT.App.UCenter
{
    /// <summary>
    /// ģͱʵ
    /// </summary>
    public class UcConfig 
    {
        public const string assShortName = "UCenter";
        public const string assVersion = "3.7";
        public const string tabPrefix = "ucl_";
        public readonly static bool assSetuped = false;
        public readonly static string indexPath = "";
        public readonly static int registerEmailTempletId = 0;
        public readonly static int getpasswordEmailTempletId = 0;
        static UcConfig()
        {
            Model_AppPlugin app = PluginConfig.GetModel_AppPlugin("PlugNT.App.UCenter");
            assSetuped = app.setuped;
            indexPath = app.indexPath;
            if (File.Exists(SiteConfig.ConfigPath + "plugin.config"))
            {
                XmlDocument xml = new XmlDocument();
                xml.Load(SiteConfig.ConfigPath + "plugin.config");
                XmlNode control = xml.SelectSingleNode("/configs/plugitem[@name='PlugNT.App.UCenter']");
                XmlNode idlist = control.SelectSingleNode("assembly/ucenter/emailtempletidlist");
                string[] arr = idlist.InnerText.Split(',');
                registerEmailTempletId = int.Parse(arr[0]);
                getpasswordEmailTempletId = int.Parse(arr[1]);
           
            }
        }
        /// <summary>
        /// UCߵ
        /// </summary>
        /// <param name="filepath"></param>
        /// <returns></returns>
        public static string GetLeftFormat(string filepath)
        {
            StringBuilder sb = new StringBuilder();
            foreach (KeyValuePair<string,Model_AppPlugin> app in PluginConfig.appList)
            {
                if (app.Value.setuped)
                {
                    sb.Append(app.Value.ucLeftmenu);
                }
            }
            return PlugNT.Cms.Utility.DataHelper.GetCacheFile(filepath, sb.ToString());
        }
    }
}

