using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;
using System.Data;
using PlugNT.Safe;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.App.UCenter.Model;
namespace PlugNT.App.UCenter.DAL
{
    public class UMessage 
    {
        internal const string currTableName = UcConfig.tabPrefix + "message";
        public UMessageInfo GetUMessageInfo(int id)
        {
            UMessageInfo model = new UMessageInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], admin_id, user_id, [info], [remark], create_time, [looked], [type]", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["admin_id"].ToString() != "")
                    {
                        model.admin_id = int.Parse(dr["admin_id"].ToString());
                    }
                    if (dr["user_id"].ToString() != "")
                    {
                        model.user_id = int.Parse(dr["user_id"].ToString());
                    }
                    model.info = dr["info"].ToString();
                    model.remark = dr["remark"].ToString();
                    if (dr["create_time"].ToString() != "")
                    {
                        model.create_time = DateTime.Parse(dr["create_time"].ToString());
                    }
                    if (dr["looked"].ToString() != "")
                    {
                        model.looked = int.Parse(dr["looked"].ToString());
                    }
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        public static string GetAddSql(UMessageInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " + currTableName + " (");
            strSql.Append("admin_id,user_id,");
            strSql.Append("[info],[remark],create_time,[looked],[type])");
            strSql.Append(" values ( ");
            strSql.Append(model.admin_id.ToString() + ",");
            strSql.Append(model.user_id.ToString() + ",");
            strSql.Append(SqlHelper.FieldFilter(model.info) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.remark) + ",");
            strSql.Append("'" + model.create_time.ToString() + "',");
            strSql.Append(model.looked.ToString() + ",");
            strSql.Append(model.type.ToString());
            strSql.Append(" ) ");
            return strSql.ToString();
        }
        public bool Delete(string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from " + currTableName);
            strSql.Append(" where 1=1 " + andWhere);
            return DbHelper.ExecuteSql(strSql.ToString()) > 0;
        }
        public DataTable GetList(string andWhere)
        {
            return DbHelper.GetDataTable(string.Format("select * from [" + currTableName + "] where 1=1 {0}", andWhere));
        }
        public DataTable GetList(int topCount, string andWhere)
        {
            string tmpTopCount = (topCount <= 0) ? "" : " top " + topCount.ToString();
            return DbHelper.GetDataTable(string.Format("select {0} * from [" + currTableName + "] where 1=1 {1}", tmpTopCount, andWhere));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        private static IDataReader GetReader(int topCount, string colNames, string andWhere)
        {
            string sql = "select " + (topCount >0  ? "" : "top " + topCount) + " " + colNames + " from " + currTableName + " where 1=1 " + andWhere;
            return DbHelper.ExecuteReader(sql);
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetUDataList(int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(andWhere.ToString());
            StringBuilder strColNames = new StringBuilder();
            strColNames.Append("a.*,");
            strColNames.Append("b." + UserConfig.GetFieldName("username") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("email") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("pic"));
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), "id");
            sql = SqlHelper.Join(sql, "as a", strColNames.ToString(),
                "left join " + UserConfig.UsersTableName + " as b on a.user_id=b." + UserConfig.GetFieldName("id") + " order by a.id");
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

