/**********************************************************************************
 * ˵     ҳ(ݷʲ)
 * ڣ     2009.6.13
 * ޸ڣ     2012.02.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using PlugNT.Safe;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.App.UCenter.Model;
namespace PlugNT.App.UCenter.DAL
{
    /// <summary>
    /// ҳ
    /// </summary>
    public class UGrade
    {
        public static readonly string currTableName = UcConfig.tabPrefix + "grade";
        private static Dictionary<string, string> grades;
        static UGrade()
        {
            grades = new Dictionary<string, string>();
            IDataReader dr = GetReader(-1, "*", "");
            if (dr != null)
            {
                while (dr.Read())
                {
                    grades.Add(dr["grade"].ToString(), dr["grade_name"].ToString());
                }
                dr.Close();
            }
        }
        
        /// <summary>
        /// õģ
        /// </summary>
        /// <param grade_name="id"></param>
        /// <returns></returns>
        public UGradeInfo GetUGradeInfo(int id)
        {
            UGradeInfo model = null;
            IDataReader dr = GetReader(1,"*", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    model = new UGradeInfo();
                    model.id = int.Parse(dr["id"].ToString());
                    model.grade = int.Parse(dr["grade"].ToString());
                    model.grade_name = dr["grade_name"].ToString();
                }
                dr.Close();
            }
            return model;
        }
        /// <summary>
        /// (ȼС09)
        /// </summary>
        /// <param grade_name="model"></param>
        /// <returns></returns>
        public bool Add(UGradeInfo model)
        {
            if (model.grade <0 || model.grade > 9 )
            {
                return false;
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " +  currTableName);
            strSql.Append(" values (");
            strSql.Append(model.grade.ToString()+ ",");
            strSql.Append( SqlHelper.FieldFilter(model.grade_name));
            strSql.Append(")");
            if (DbHelper.ExecuteSql(strSql.ToString()) > 0) 
            {
                if (!grades.ContainsKey(model.grade.ToString()))
                {
                    grades.Add(model.grade.ToString(), model.grade_name);
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param grade_name="model"></param>
        /// <returns></returns>
        public bool Update(UGradeInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " +  currTableName);
            strSql.Append(" set grade_name=" + SqlHelper.FieldFilter(model.grade_name));
            strSql.Append(" where id=" + model.id);
            if (DbHelper.ExecuteSql(strSql.ToString()) > 0)
            {
                if (grades.ContainsKey(model.grade.ToString()))
                {
                    grades[model.grade.ToString()] =  model.grade_name;
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param grade_name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from " + currTableName);
            strSql.Append(" where id= " + id);
            UGradeInfo uinfo = GetUGradeInfo(id);
            string key = (uinfo != null) ? uinfo.grade.ToString() : "";
            if (DbHelper.ExecuteSql(strSql.ToString()) > 0)
            {
                if (grades.ContainsKey(key))
                {
                    grades.Remove(key);
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        public string GetGradeName(string dicGrade)
        {
            string reString = "";
            grades.TryGetValue(dicGrade, out reString);
            return reString;
        }
        public string GetFormatGradeNames(string strFormat)
        {
            StringBuilder sb = new StringBuilder();
            foreach (System.Collections.Generic.KeyValuePair<string, string> kValue in grades)
            {
                sb.Append(string.Format(strFormat, kValue.Key, kValue.Value));
            }
            return sb.ToString();
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        public DataTable GetList()
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,grade,grade_name from " + currTableName);
            return DbHelper.GetDataTable(strSql.ToString());
        }
        public DataTable GetList(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,grade,grade_name from " + currTableName);
            strSql.Append(" where id=" + id);
            return DbHelper.GetDataTable(strSql.ToString());
        }
    }
}

