using System.Web;
using System.Text;
using System.IO;
using System.Net;
using System;
using System.Collections.Generic;
using System.Xml;
namespace PlugNT.App.Payment.Alipay
{
    /// <summary>
    /// Submit
    /// ܣ֧ӿύ
    /// ϸ֧ӿڱHTMLıȡԶHTTP
    /// 汾3.3
    /// ޸ڣ2011-07-05
    /// ˵
    /// ´ֻΪ˷̻Զṩ룬̻ԸԼվҪռĵд,һҪʹøô롣
    /// ôѧϰо֧ӿʹãֻṩһο
    /// </summary>
    public class Submit
    {
        private static string GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
        private static string _key = "";
        private static string _input_charset = "";
        private static string _sign_type = "";
        static Submit()
        {
            _key = Config.Key.Trim();
            _input_charset = Config.Input_charset.Trim().ToLower();
            _sign_type = Config.Sign_type.Trim().ToUpper();
        }
        /// <summary>
        /// ʱǩ
        /// </summary>
        /// <param name="sPara">֧Ĳ</param>
        /// <returns>ǩ</returns>
        private static string BuildRequestMysign(Dictionary<string, string> sPara)
        {
            string prestr = Core.CreateLinkString(sPara);
            string mysign = "";
            switch (_sign_type)
            {
                case "MD5":
                    mysign = AlipayMD5.Sign(prestr, _key, _input_charset);
                    break;
                default:
                    mysign = "";
                    break;
            }
            return mysign;
        }
        /// <summary>
        /// Ҫ֧Ĳ
        /// </summary>
        /// <param name="sParaTemp">ǰĲ</param>
        /// <returns>ҪĲ</returns>
        private static Dictionary<string, string> BuildRequestPara(SortedDictionary<string, string> sParaTemp)
        {
            Dictionary<string, string> sPara = new Dictionary<string, string>();
            string mysign = "";
            sPara = Core.FilterPara(sParaTemp);
            mysign = BuildRequestMysign(sPara);
            sPara.Add("sign", mysign);
            sPara.Add("sign_type", _sign_type);
            return sPara;
        }
        /// <summary>
        /// Ҫ֧Ĳ
        /// </summary>
        /// <param name="sParaTemp">ǰĲ</param>
        /// <param name="code">ַ</param>
        /// <returns>ҪĲַ</returns>
        private static string BuildRequestParaToString(SortedDictionary<string, string> sParaTemp, Encoding code)
        {
            Dictionary<string, string> sPara = new Dictionary<string, string>();
            sPara = BuildRequestPara(sParaTemp);
            string strRequestData = Core.CreateLinkStringUrlencode(sPara, code);
            return strRequestData;
        }
        /// <summary>
        /// ԱHTMLʽ죨Ĭϣ
        /// </summary>
        /// <param name="sParaTemp"></param>
        /// <param name="strMethod">ύʽֵѡpostget</param>
        /// <param name="strButtonValue">ȷϰťʾ</param>
        /// <returns>ύHTMLı</returns>
        public static string BuildRequest(SortedDictionary<string, string> sParaTemp, string strMethod, string strButtonValue)
        {
            Dictionary<string, string> dicPara = new Dictionary<string, string>();
            dicPara = BuildRequestPara(sParaTemp);
            StringBuilder sbHtml = new StringBuilder();
            sbHtml.Append("<form id='alipaysubmit' name='alipaysubmit' action='" + GATEWAY_NEW + "_input_charset=" + _input_charset + "' method='" + strMethod.ToLower().Trim() + "'>");
            foreach (KeyValuePair<string, string> temp in dicPara)
            {
                sbHtml.Append("<input type='hidden' name='" + temp.Key + "' value='" + temp.Value + "'/>");
            }
            sbHtml.Append("<input type='submit' value='" + strButtonValue + "' style='display:none;'></form>");
            sbHtml.Append("<script>document.forms['alipaysubmit'].submit();</script>");
            return sbHtml.ToString();
        }
        /// <summary>
        /// ģԶHTTPPOSTʽ첢ȡ֧Ĵ
        /// </summary>
        /// <param name="sParaTemp"></param>
        /// <returns>֧</returns>
        public static string BuildRequest(SortedDictionary<string, string> sParaTemp)
        {
            Encoding code = Encoding.GetEncoding(_input_charset);
            string strRequestData = BuildRequestParaToString(sParaTemp,code);
            byte[] bytesRequestData = code.GetBytes(strRequestData);
            string strUrl = GATEWAY_NEW + "_input_charset=" + _input_charset;
            string strResult = "";
            try
            {
                HttpWebRequest myReq = (HttpWebRequest)HttpWebRequest.Create(strUrl);
                myReq.Method = "post";
                myReq.ContentType = "application/x-www-form-urlencoded";
                myReq.ContentLength = bytesRequestData.Length;
                Stream requestStream = myReq.GetRequestStream();
                requestStream.Write(bytesRequestData, 0, bytesRequestData.Length);
                requestStream.Close();
                HttpWebResponse HttpWResp = (HttpWebResponse)myReq.GetResponse();
                Stream myStream = HttpWResp.GetResponseStream();
                StreamReader reader = new StreamReader(myStream, code);
                StringBuilder responseData = new StringBuilder();
                String line;
                while ((line = reader.ReadLine()) != null)
                {
                    responseData.Append(line);
                }
                myStream.Close();
                strResult = responseData.ToString();
            }
            catch (Exception exp)
            {
                strResult = ""+exp.Message;
            }
            return strResult;
        }
        /// <summary>
        /// ģԶHTTPPOSTʽ첢ȡ֧Ĵļϴ
        /// </summary>
        /// <param name="sParaTemp"></param>
        /// <param name="strMethod">ύʽֵѡpostget</param>
        /// <param name="fileName">ļ·</param>
        /// <param name="data">ļ</param>
        /// <param name="contentType">ļ</param>
        /// <param name="lengthFile">ļ</param>
        /// <returns>֧</returns>
        public static string BuildRequest(SortedDictionary<string, string> sParaTemp, string strMethod, string fileName, byte[] data, string contentType, int lengthFile)
        {
            Dictionary<string, string> dicPara = new Dictionary<string, string>();
            dicPara = BuildRequestPara(sParaTemp);
            string strUrl = GATEWAY_NEW + "_input_charset=" + _input_charset;
            HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(strUrl);
            request.Method = strMethod;
            string boundaryValue = DateTime.Now.Ticks.ToString("x");
            string boundary = "--" + boundaryValue;
            request.ContentType = "\r\nmultipart/form-data; boundary=" + boundaryValue;
            request.KeepAlive = true;
            StringBuilder sbHtml = new StringBuilder();
            foreach (KeyValuePair<string, string> key in dicPara)
            {
                sbHtml.Append(boundary + "\r\nContent-Disposition: form-data; name=\"" + key.Key + "\"\r\n\r\n" + key.Value + "\r\n");
            }
            sbHtml.Append(boundary + "\r\nContent-Disposition: form-data; name=\"withhold_file\"; filename=\"");
            sbHtml.Append(fileName);
            sbHtml.Append("\"\r\nContent-Type: " + contentType + "\r\n\r\n");
            string postHeader = sbHtml.ToString();
            Encoding code = Encoding.GetEncoding(_input_charset);
            byte[] postHeaderBytes = code.GetBytes(postHeader);
            byte[] boundayBytes = Encoding.ASCII.GetBytes("\r\n" + boundary + "--\r\n");
            long length = postHeaderBytes.Length + lengthFile + boundayBytes.Length;
            request.ContentLength = length;
            Stream requestStream = request.GetRequestStream();
            Stream myStream;
            try
            {
                requestStream.Write(postHeaderBytes, 0, postHeaderBytes.Length);
                requestStream.Write(data, 0, lengthFile);
                requestStream.Write(boundayBytes, 0, boundayBytes.Length);
                HttpWebResponse HttpWResp = (HttpWebResponse)request.GetResponse();
                myStream = HttpWResp.GetResponseStream();
            }
            catch (WebException e)
            {
                return e.ToString();
            }
            finally
            {
                if (requestStream != null)
                {
                    requestStream.Close();
                }
            }
            StreamReader reader = new StreamReader(myStream, code);
            StringBuilder responseData = new StringBuilder();
            String line;
            while ((line = reader.ReadLine()) != null)
            {
                responseData.Append(line);
            }
            myStream.Close();
            return responseData.ToString();
        }
        /// <summary>
        /// ڷ㣬ýӿquery_timestampȡʱĴ
        /// ע⣺Զ̽XMLIISй
        /// </summary>
        /// <returns>ʱַ</returns>
        public static string Query_timestamp()
        {
            try
            {
                string url = GATEWAY_NEW + "service=query_timestamp&partner=" + Config.Partner + "&_input_charset=" + Config.Input_charset;
                string encrypt_key = "";
                XmlTextReader Reader = new XmlTextReader(url);
                XmlDocument xmlDoc = new XmlDocument();
                xmlDoc.Load(Reader);
                encrypt_key = xmlDoc.SelectSingleNode("/alipay/response/timestamp/encrypt_key").InnerText;
                return encrypt_key;
            }
            catch
            {
                return "";
            }
        }
    }
}

