using System.Web;
using System.Text;
using System.IO;
using System.Net;
using System;
using System.Collections.Generic;
namespace PlugNT.App.Payment.Alipay
{
    /// <summary>
    /// Notify
    /// ܣ֧֪ͨ
    /// ϸ֧ӿ֪ͨ
    /// 汾3.3
    /// ޸ڣ2011-07-05
    /// '˵
    /// ´ֻΪ˷̻Զṩ룬̻ԸԼվҪռĵд,һҪʹøô롣
    /// ôѧϰо֧ӿʹãֻṩһο
    /// 
    /// //////////////////////ע/////////////////////////////
    /// ֪ͨʱɲ鿴дlog־дTXTݣ֪ͨǷ 
    /// </summary>
    public class Notify
    {
        private string _partner = "";               //ID
        private string _key = "";                   //̻˽Կ
        private string _input_charset = "";         //ʽ
        private string _sign_type = "";             //ǩʽ
        private string Https_veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&";
        /// <summary>
        /// 캯
        /// ļгʼ
        /// </summary>
        /// <param name="inputPara">֪ͨز</param>
        /// <param name="notify_id">֪֤ͨID</param>
        public Notify()
        {
            _partner = Config.Partner.Trim();
            _key = Config.Key.Trim();
            _input_charset = Config.Input_charset.Trim().ToLower();
            _sign_type = Config.Sign_type.Trim().ToUpper();
        }
        /// <summary>
        ///  ֤ϢǷ֧ĺϷϢ
        /// </summary>
        /// <param name="inputPara">֪ͨز</param>
        /// <param name="notify_id">֪֤ͨID</param>
        /// <param name="sign">֧ɵǩ</param>
        /// <returns>֤</returns>
        public bool Verify(SortedDictionary<string, string> inputPara, string notify_id, string sign)
        {
            bool isSign = GetSignVeryfy(inputPara, sign);
            string responseTxt = "true";
            if (notify_id != null && notify_id != "") { responseTxt = GetResponseTxt(notify_id); }
            if (responseTxt == "true" && isSign)//֤ɹ
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ȡǩַã
        /// </summary>
        /// <param name="inputPara">֪ͨز</param>
        /// <returns>ǩַ</returns>
        private string GetPreSignStr(SortedDictionary<string, string> inputPara)
        {
            Dictionary<string, string> sPara = new Dictionary<string, string>();
            sPara = Core.FilterPara(inputPara);
            string preSignStr = Core.CreateLinkString(sPara);
            return preSignStr;
        }
        /// <summary>
        /// ȡʱǩ֤
        /// </summary>
        /// <param name="inputPara">֪ͨز</param>
        /// <param name="sign">Աȵǩ</param>
        /// <returns>ǩ֤</returns>
        private bool GetSignVeryfy(SortedDictionary<string, string> inputPara, string sign)
        {
            Dictionary<string, string> sPara = new Dictionary<string, string>();
            sPara = Core.FilterPara(inputPara);
            
            string preSignStr = Core.CreateLinkString(sPara);
            bool isSgin = false;
            if (sign != null && sign != "")
            {
                switch (_sign_type)
                {
                    case "MD5":
                        isSgin = AlipayMD5.Verify(preSignStr, sign, _key, _input_charset);
                        break;
                    default:
                        break;
                }
            }
            return isSgin;
        }
        /// <summary>
        /// ȡǷ֧֤
        /// </summary>
        /// <param name="notify_id">֪֤ͨID</param>
        /// <returns>֤</returns>
        private string GetResponseTxt(string notify_id)
        {
            string veryfy_url = Https_veryfy_url + "partner=" + _partner + "&notify_id=" + notify_id;
            string responseTxt = Get_Http(veryfy_url, 120000);
            return responseTxt;
        }
        /// <summary>
        /// ȡԶ̷ATN
        /// </summary>
        /// <param name="strUrl">ָURL·ַ</param>
        /// <param name="timeout">ʱʱ</param>
        /// <returns>ATN</returns>
        private string Get_Http(string strUrl, int timeout)
        {
            string strResult;
            try
            {
                HttpWebRequest myReq = (HttpWebRequest)HttpWebRequest.Create(strUrl);
                myReq.Timeout = timeout;
                HttpWebResponse HttpWResp = (HttpWebResponse)myReq.GetResponse();
                Stream myStream = HttpWResp.GetResponseStream();
                StreamReader sr = new StreamReader(myStream, Encoding.Default);
                StringBuilder strBuilder = new StringBuilder();
                while (-1 != sr.Peek())
                {
                    strBuilder.Append(sr.ReadLine());
                }
                strResult = strBuilder.ToString();
            }
            catch (Exception exp)
            {
                strResult = "" + exp.Message;
            }
            return strResult;
        }
    }
}

