using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Page;
namespace PlugNT.App.Payment.Web
{
    /// <summary>
    /// Ajax첽ִࣨʹSessionʱҪ̳IRequiresSessionState
    /// </summary>
    public class Ajax : IHttpHandler, IRequiresSessionState
    {
        private string plugntCookieUcode = Key_Flags.CookieUserCode;
        private string userName = "";
        public void ProcessRequest(HttpContext context)
        {
            Uri uri_f = context.Request.UrlReferrer;
            if (uri_f == null)
            {
                uri_f = context.Request.Url;
            }
            if (uri_f != null)
            {
                string host = uri_f.Host.ToLower();
                if (host.StartsWith("localhost") || host.EndsWith(SiteConfig.DoMain))
                {
                    string arg = context.Request["a"] as string;
                    string responsestr = "{\"success\": false, \"error\": \"ʧܣ\"}";
                    if (context.Session[Key_Flags.SessionUser] != null)
                    {
                        userName = context.Session[Key_Flags.SessionUser].ToString();
                    }
                    switch (arg)
                    {
                        case "shw_flow":
                            responsestr = ShowFlow(context);
                            break;
                        case "pay_money":
                            responsestr = PayMoney(context);
                            break;
                        default:
                            break;
                    }
                    context.Response.Write(responsestr);
                }
                else
                {
                    context.Response.Write("{\"success\": false, \"error\": \"ʧܣǷ\"}");
                }
            }
            else
            {
                context.Response.Write("{\"success\": false, \"error\": \"ʧܣǷʣ\"}");
            }
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
        private string ShowFlow(HttpContext context)
        {
            if (!IsLogined(context))
            {
                return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
            }
            string sUserId = IUser.GetObjectString(UserConfig.GetFieldName("id"),
                "and " + UserConfig.GetFieldName("username") + "=" + SqlHelper.FieldFilter(GetUserName(context)));
            if (!PlugNT.Common.Utils.IsNumeric(sUserId))
            {
                return "{\"success\": false, \"error\": \"ʾ¼ʧܣ˺Ųڣ\"}";
            }
            int type = (context.Request["type"] == null) ? -1 : (PlugNT.Common.Utils.IsNumeric(context.Request["type"].Trim()) ? int.Parse(context.Request["type"].Trim()) : -1);
            int currPageCount = (context.Request["page"] == null) ? 0 : (PlugNT.Common.Utils.IsNumeric(context.Request["page"].Trim()) ? int.Parse(context.Request["page"].Trim()) : 0);
            int pageSize = (context.Request["pagesize"] == null) ? 10 : (PlugNT.Common.Utils.IsNumeric(context.Request["pagesize"].Trim()) ? int.Parse(context.Request["pagesize"].Trim()) : 10);
            int recordCount = 0;
            DataTable dt = new PlugNT.App.Payment.BLL.Flow().GetUDataList(pageSize, currPageCount, int.Parse(sUserId), type, "id", out recordCount);
            StringBuilder sb = new StringBuilder();
            foreach (DataRow dr in dt.Rows)
            {
                sb.Append("{\"id\":\"" + dr["id"].ToString() + "\",\"direction\":\"" + dr["direction"].ToString() + "\",\"money_operate\":\"" + dr["money_operate"].ToString() + "\",\"remark\":\"" + dr["remark"].ToString() + "\",\"create_time\":\"" + dr["create_time"].ToString() + "\"},");
            }
            return "{\"success\": true, \"count\":" + recordCount + ", \"list\": [" + sb.ToString().Trim(',') + "]}";
        }
        private string PayMoney(HttpContext context)
        {
            try
            {
                if (!IsLogined(context))
                {
                    return "{\"success\": false, \"error\": \"δ¼ȵ½\"}";
                }
                string usernme = GetUserName(context);
                string sUserId = IUser.GetObjectString(UserConfig.GetFieldName("id"),
                    "and " + UserConfig.GetFieldName("username") + "=" + SqlHelper.FieldFilter(userName));
                if (!PlugNT.Common.Utils.IsNumeric(sUserId))
                {
                    return "{\"success\": false, \"error\": \"֧ʧܣ˺Ųڣ\"}";
                }
                double payMoney = (context.Request["pay_money"] == null) ? -1 : (PlugNT.Common.Utils.IsDouble(context.Request["pay_money"].Trim()) ? double.Parse(context.Request["pay_money"].Trim()) : -1);
                int payId = (context.Request["pay_id"] == null) ? 0 : (PlugNT.Common.Utils.IsNumeric(context.Request["pay_id"].Trim()) ? int.Parse(context.Request["pay_id"].Trim()) : 0);
                if (payId > 0 && payMoney > 0)
                {
                    PlugNT.App.Payment.Model.PayonlineInfo payInfo = new PlugNT.App.Payment.BLL.Payonline().GetPayonlineInfo(payId);
                    if (payInfo != null)
                    {
                        PlugNT.App.Payment.Model.InchargeInfo inInfo = new PlugNT.App.Payment.Model.InchargeInfo();
                        inInfo.admin_id = 0;
                        inInfo.no = PlugNT.Cms.Custom.SysManager.GetNoString();
                        inInfo.user_id = int.Parse(sUserId);
                        inInfo.type = 1;
                        inInfo.payonline_id = payId;
                        inInfo.money = payMoney;
                        inInfo.state = 0;
                        inInfo.create_time = DateTime.Now;
                        PlugNT.App.Payment.BLL.Incharge bllIncharge = new PlugNT.App.Payment.BLL.Incharge();
                        if (bllIncharge.Add(inInfo))
                        {
                            return "{\"success\": true, \"payment_id\": " + payId + ", \"key\":\"" + payInfo.key + "\", \"pay_order_no\":\"" + inInfo.no + "\", \"pay_user_name\": \"" + usernme + "\", \"pay_order_amount\": " + inInfo.money + ", \"pay_subject\": \"Աֵ\"}";
                        }
                        else
                        {
                            return "{\"success\": false, \"error\": \"ֵʧܣ\"}";
                        }
                    }
                    else
                    {
                        return "{\"success\": false, \"error\": \"ֵʧܣ֧ڣ\"}";
                    }
                }
                else
                {
                    return "{\"success\": false, \"error\": \"ֵʧܣ\"}";
                }
            }
            catch
            {
                return "{\"success\": false, \"error\": \"ֵ쳣\"}";
            }
        }
        private bool IsLogined(HttpContext context)
        {
            string username = Key_Flags.SessionUser;
            return (context.Session[username] != null);
        }
        private string GetUserName(HttpContext context)
        {
            string username = Key_Flags.SessionUser;
            return (context.Session[username] != null) ? context.Session[username].ToString() : "";
        }
    }
}

