using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using PlugNT.Common;
using PlugNT.Cms.Page;
using PlugNT.Cms.Custom;
using PlugNT.App.Payment.Model;
using PlugNT.App.Payment.BLL;
namespace PlugNT.App.Payment.Web
{
    public partial class SetPayment : AdminPager
    {
        private string sid = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            string type = (Request.QueryString["t"] == null) ? "" : Request.QueryString["t"].Trim();
            sid = (Request.QueryString["id"] == null) ? "0" : Request.QueryString["id"].Trim();
            if (!IsPostBack)
            {
                switch (type)
                {
                    case "add":
                        btnUpdate.Text = "  ";
                        break;
                    case "edit":
                        btnUpdate.Text = " ޸ ";
                        txtKey.ReadOnly = true;
                        break;
                    case "delete":
                        Delete();
                        break;
                    default:
                        ShowMessager("ֶΰʧܣȷ·ڣ", Type_Message.Error);
                        break;
                }
                if (PayConfig.assSetuped)
                {
                    BindData();
                    hidAction.Value = type;
                }
                else
                {
                    ShowMessager("δװ֧Ȱװʹã", Type_Message.Error);
                }
            }
        }
        private void BindData()
        {
            if (sid != "" && sid != "0")
            {
                PayonlineInfo info = new Payonline().GetPayonlineInfo(int.Parse(sid));
                if (info != null)
                {
                    txtId.Text = info.id.ToString();
                    txtId.Enabled = false;
                    txtKey.Text = info.key;
                    txtName.Text = info.name;
                    txtAccount.Text = info.account;
                    txtPassword.Text = info.password;
                    txtFare.Text = info.fare.ToString();
                    rblType.SelectedValue = info.type.ToString();
                    rblEnable.SelectedValue = info.enable ? "1" : "0";
                    txtDescription.Text = info.description;
                    txtArrStr.Text = info.arr_str;
                }
            }
            else
            {
                txtId.Text = (Payonline.GetMaxId() + 1).ToString();
            }
        }
        private void Delete()
        {
            this.CheckReadOnly();
            if (new PlugNT.App.Payment.BLL.Payonline().Delete(int.Parse(sid)))
            {
                Response.Redirect("./Manage.aspx");
            }
            else
            {
                ShowMessager("֧ɾʧܣ", Type_Message.Error);
            }
        }
        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            this.CheckReadOnly();
            PayonlineInfo info = new PayonlineInfo();
            info.id = int.Parse(txtId.Text.Trim());
            info.key = txtKey.Text.Trim();
            info.name = txtName.Text.Trim();
            info.account = txtAccount.Text.Trim();
            info.password = txtPassword.Text.Trim();
            info.fare = double.Parse(txtFare.Text.Trim());
            info.type = int.Parse(rblType.SelectedValue.Trim());
            info.enable = rblEnable.SelectedValue == "1";
            info.description = txtDescription.Text.Trim();
            info.arr_str = txtArrStr.Text.Trim();
            PlugNT.App.Payment.BLL.Payonline bllPayonline = new PlugNT.App.Payment.BLL.Payonline();
            if (hidAction.Value == "add")
            {
                if (bllPayonline.GetPayonlineInfo(info.id) == null)
                {
                    if (bllPayonline.Add(info))
                    {
                        Response.Redirect("./Manage.aspx");
                    }
                    else
                    {
                        ShowMessager("֧ʧܣ", Type_Message.Error);
                    }
                }
                else
                {
                    ShowMessager("֧ʧܣñŵļ¼Ѵڣ", Type_Message.Error);
                }
            }
            else
            {
                if (hidAction.Value == "edit")
                {
                    info.id = int.Parse(sid);
                    if (bllPayonline.Update(info))
                    {
                        Response.Redirect("./Manage.aspx");
                    }
                    else
                    {
                        ShowMessager("޸֧ʧܣ", Type_Message.Error);
                    }
                }
                else
                {
                    ShowMessager("޸֧ʧܣδ֪", Type_Message.Error);
                }
            }
        }
    }
}

