using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;
using System.Data;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.App.Payment.Model;
namespace PlugNT.App.Payment.DAL
{
    public class Payonline
    {
        public static readonly string currTableName = PayConfig.tabPrefix + "payonline";
        public bool Add(PayonlineInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " + currTableName + " (");
            strSql.Append("[id],[key],[name],[account],[password],[fare],[type],[enable],[description],arr_str)");
            strSql.Append(" values (");
            strSql.Append(model.id.ToString() + ",");
            strSql.Append(SqlHelper.FieldFilter(model.key) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.name) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.account) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.password) + ",");
            strSql.Append(model.fare.ToString() + ",");
            strSql.Append(model.type.ToString() + ",");
            strSql.Append((model.enable ? "1" : "0") + ",");
            strSql.Append(SqlHelper.FieldFilter(model.description) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.arr_str));
            
            strSql.Append(")");
            return DbHelper.ExecuteSql(strSql.ToString()) > 0;
        }
        public bool Update(PayonlineInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + " set ");
            strSql.Append("[key]=" + SqlHelper.FieldFilter(model.key) + ",");
            strSql.Append("[name]='" + SqlHelper.FieldFilter(model.name) + ",");
            strSql.Append("[account]=" + SqlHelper.FieldFilter(model.account) + ",");
            strSql.Append("[password]=" + SqlHelper.FieldFilter(model.password) + ",");
            strSql.Append("[fare]=" + model.fare.ToString() + ",");
            strSql.Append("[type]=" + model.type.ToString() + ",");
            strSql.Append("[enable]=" + (model.enable ? "1" : "0") + ",");
            strSql.Append("[description]=" + SqlHelper.FieldFilter(model.description) + ",");
            strSql.Append("arr_str=" + SqlHelper.FieldFilter(model.arr_str));
            strSql.Append(" where id=" + model.id.ToString());
            return DbHelper.ExecuteSql(strSql.ToString()) > 0;
        }
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from [" + currTableName + "] ");
            strSql.Append(" where id=" + id.ToString());
            return DbHelper.ExecuteSql(strSql.ToString()) > 0;
        }
        private static IDataReader GetReader(int topCount, string colNames, string andWhere)
        {
            string sql = "select " + (topCount == -1 ? "" : "top " + topCount) + " " + colNames + " from " + currTableName + " where 1=1 " + andWhere;
            return DbHelper.ExecuteReader(sql);
        }
        public DataTable GetList( string andWhere)
        {
            return DbHelper.GetDataTable(string.Format("select * from [" + currTableName + "] where 1=1 {0}",  andWhere));
        }
        public int GetCount( string andWhere)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " +  andWhere;
            object obj = DbHelper.GetSingle(sql);
            return obj == null ? 0 : int.Parse(obj.ToString());
        }
        public static int GetMaxId()
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 max(id) from " + currTableName);
            object obj = DbHelper.GetSingle(strSql.ToString());
            return obj == null ? 0 : int.Parse(obj.ToString());
        }
        public static string GetName(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [name] from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        public static string GetKey(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [key] from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        public static double GetFare(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [fare] from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToDouble(DbHelper.GetSingle(strSql.ToString()));
        }
        public PayonlineInfo GetPayonlineInfo(int id)
        {
            PayonlineInfo model = null;
            IDataReader dr = GetReader(1, "*", " and id=" + id.ToString());
            if (dr != null)
            {
                if (dr.Read())
                {
                    model = new PayonlineInfo();
                    model.id = int.Parse(dr["id"].ToString());
                    model.key = dr["key"].ToString();
                    model.name = dr["name"].ToString();
                    model.account = dr["account"].ToString();
                    model.password = dr["password"].ToString();
                    model.fare = double.Parse(dr["fare"].ToString());
                    model.type = int.Parse(dr["type"].ToString());
                    model.enable = dr["enable"].ToString()=="1";
                    model.description = dr["description"].ToString();
                    model.arr_str = dr["arr_str"].ToString();
                }
                dr.Close();
            }
            return model;
        }
    }
}

