using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;
using System.Data;
using PlugNT.Safe;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.BLL;
using PlugNT.App.Payment.Model;
namespace PlugNT.App.Payment.DAL
{
    public class Incharge
    {
        public static string currTableName = PayConfig.tabPrefix + "incharge";
        private static InchargeInfo GetInchargeInfo(IDataReader dr)
        {
            InchargeInfo model = new InchargeInfo();
            bool isRead = false;
            if (dr != null)
            {
                if (dr.Read())
                {
                    model.id = int.Parse(dr["id"].ToString());
                    model.no = dr["no"].ToString();
                    model.admin_id = int.Parse(dr["admin_id"].ToString());
                    model.user_id = int.Parse(dr["user_id"].ToString());
                    model.state = int.Parse(dr["state"].ToString());
                    model.money = double.Parse(dr["money"].ToString());
                    model.payonline_id = int.Parse(dr["payonline_id"].ToString());
                    model.create_time = DateTime.Parse(dr["create_time"].ToString());
                    model.type = int.Parse(dr["type"].ToString());
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        public static InchargeInfo GetInchargeInfo(int id)
        {
            IDataReader dr = GetReader(1, "*", " and id=" + id.ToString());
            return GetInchargeInfo(dr);
        }
        public static InchargeInfo GetInchargeInfo(string no)
        {
            IDataReader dr = GetReader(1, "*", " and no=" + SqlHelper.FieldFilter(no));
            return GetInchargeInfo(dr);
        }
        public bool Add(InchargeInfo model)
        {
            return DbHelper.ExecuteSql(GetAddSql(model))>0 ;
        }
        internal static string GetAddSql(InchargeInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " + currTableName + " (");
            strSql.Append("[no],admin_id,user_id,[state],[money],payonline_id,create_time,[type])");
            strSql.Append(" values (");
            strSql.Append(SqlHelper.FieldFilter(model.no));
            strSql.Append(" " + model.admin_id.ToString() + ",");
            strSql.Append(" " + model.user_id.ToString() + ",");
            strSql.Append(" " + model.state.ToString() + ",");
            strSql.Append(" " + model.money.ToString() + ",");
            strSql.Append(" " + model.payonline_id.ToString() + ",");
            strSql.Append("'" + model.create_time.ToString() + "',");
            strSql.Append(" " + model.type.ToString());
            strSql.Append(")");
            return strSql.ToString();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fields"></param> 
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Update(List<Model_Field> fields, string andWhere)
        {
            if (fields.Count <= 0)
            {
                return false;
            }
            StringBuilder sbField = new StringBuilder();
            foreach (Model_Field field in fields)
            {
                if (field.fieldType == Type_Field.integerType)
                {
                    sbField.Append("," + field.fieldName + "=" + (string.IsNullOrEmpty(field.fieldValue) ? "0" : field.fieldValue));
                }
                else
                {
                    sbField.Append("," + field.fieldName + "='" + field.fieldValue.Replace("'", "''") + "'");
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append(sbField.ToString().TrimStart(','));
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        public bool Delete(int id, string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from [" + currTableName + "] ");
            strSql.Append(" where id=" + id.ToString() + " " + andWhere);
            return DbHelper.ExecuteSql(strSql.ToString()) > 0;
        }
        /// <summary>
        /// ֵ
        /// </summary>
        /// <param name="adminId">Աid</param>
        /// <param name="chargeNo">ֵ򶩵</param>
        /// <param name="error"></param>
        /// <returns></returns>
        public bool PayFor(int adminId, string chargeNo, out string error)
        {
            error = "";
            bool flag = false;
            List<string> sqlList = new List<string>();
            InchargeInfo incharge = Incharge.GetInchargeInfo(chargeNo);
            if (incharge == null)
            {
                error = "ֵ" + chargeNo + "¼ڣ";
                return false;
            }
            if (incharge.state != 0)
            {
                if (incharge.state == 1)
                {
                    error = "Ա" + incharge.user_id.ToString() + "ѳֵ";
                }
                else
                {
                    error = "Ա" + incharge.user_id.ToString() + "˿";
                }
                return false;
            }
            string s_id = UserConfig.GetFieldName("id");
            string s_money = UserConfig.GetFieldName("money");
            string s_enable = UserConfig.GetFieldName("enable");
            string[] arrUser = IUser.GetArray(s_money + "," + s_enable, "and " + UserConfig.GetFieldName("id") + "=" + incharge.user_id.ToString());
            if (arrUser == null)
            {
                error = "Ա" + incharge.user_id.ToString() + "˺Ųڣ";
                return false;
            }
            if (arrUser[1] != "1")
            {
                error = "Ա" + incharge.user_id.ToString() + "˺ѽã";
                return false;
            }
            double tmp_money = incharge.money;
            FlowInfo flowIncharg = new FlowInfo();
            flowIncharg.user_id = incharge.user_id;
            flowIncharg.admin_id = adminId;
            flowIncharg.no = SysManager.GetNoString();
            flowIncharg.direction = 1;      
            flowIncharg.money_operate = tmp_money;
            if (incharge.payonline_id > 0)
            {
                string name = Payonline.GetName(incharge.payonline_id);
                flowIncharg.remark = (name != "" ? name : "δ֪") + "ֵ";
            }
            else
            {
                flowIncharg.remark = "ֵֶ";
            }
            flowIncharg.create_time = DateTime.Now;
            flowIncharg.type = 1;
            string addInchargeFlowSql = Flow.GetAddSql(flowIncharg);
            StringBuilder updateFlowSql = new StringBuilder();
            updateFlowSql.Append("update " + Incharge.currTableName + " set ");
            updateFlowSql.Append("[money]=" + tmp_money.ToString() + ",admin_id=" + adminId.ToString() + ",[state]=1");
            updateFlowSql.Append(" where [id]=" + incharge.id.ToString());
            StringBuilder updateUserSql = new StringBuilder();
            updateUserSql.Append("update " + UserConfig.UsersTableName + " set ");
            updateUserSql.Append("[" + s_money + "]=[" + s_money + "]+" + tmp_money.ToString());
            updateUserSql.Append(" where " + s_id + "=" + incharge.user_id.ToString());
            sqlList.Add(addInchargeFlowSql);
            sqlList.Add(updateFlowSql.ToString());
            sqlList.Add(updateUserSql.ToString());
            string err = "";
            if (DbHelper.ExecuteSqlTran(sqlList, out err) > 0)
            {
                if (error == "")
                {
                    flag = true;
                }
                else
                {
                    SysManager.LogErrorWriteln(this.GetType(), "ֵ֧" + err);
                }
            }
            else
            {
                StringBuilder sbSql = new StringBuilder();
                foreach (string s in sqlList)
                {
                    sbSql.Append("\r\n--Sql--\r\n" + s);
                }
                SysManager.LogErrorWriteln(this.GetType(), "ֵ֧->    ţ" + chargeNo + "   Ǯ" + tmp_money.ToString() + "\r\n" + sbSql.ToString());
            }
            return flag;
        }
        /// <summary>
        /// ˳
        /// </summary>
        /// <param name="adminId">Աid</param>
        /// <param name="chargeNo">ֵ</param>
        /// <param name="error"></param>
        /// <returns></returns>
        public bool Refund(int adminId, string chargeNo, out string error)
        {
            error = "";
            bool flag = false;
            List<string> sqlList = new List<string>();
            InchargeInfo incharge = Incharge.GetInchargeInfo(chargeNo);
            if (incharge == null)
            {
                error = "ֵ" + chargeNo + "¼ڣ";
                return false;
            }
            if (incharge.state != 1)
            {
                if (incharge.state == 0)
                {
                    error = "Ա" + incharge.user_id.ToString() + "δֵ";
                }
                else
                {
                    error = "Ա" + incharge.user_id.ToString() + "˿";
                }
                return false;
            }
            if (incharge.money <= 0)
            {
                error = "Ա" + incharge.user_id.ToString() + "ֵΪ0";
                return false;
            }
            string s_id = UserConfig.GetFieldName("id");
            string s_money = UserConfig.GetFieldName("money");
            string s_enable = UserConfig.GetFieldName("enable");
            if (DbHelper.Exists("select top 1 [" + s_id + "] from " + UserConfig.UsersTableName + " where [" + s_enable + "]=1 and [" + s_id + "]=" + incharge.user_id.ToString()))
            {
                error = "Ա" + incharge.user_id.ToString() + "˺Ųڻѽã";
                return false;
            }
            FlowInfo flowIncharg = new FlowInfo();
            flowIncharg.user_id = incharge.user_id;
            flowIncharg.admin_id = adminId;
            flowIncharg.no = SysManager.GetNoString();
            flowIncharg.direction = 0;
            if (incharge.payonline_id > 0)
            {
                string name = Payonline.GetName(incharge.payonline_id);
                flowIncharg.remark = (name != "" ? name : "δ֪") + "˿";
            }
            else
            {
                flowIncharg.remark = "ֶ˿";
            }
            flowIncharg.money_operate = incharge.money;
            flowIncharg.create_time = DateTime.Now;
            flowIncharg.type = 1;
            string addInchargeFlowSql = Flow.GetAddSql(flowIncharg);
            StringBuilder updateFlowSql = new StringBuilder();
            updateFlowSql.Append("update " + Incharge.currTableName + " set ");
            updateFlowSql.Append("admin_id=" + adminId.ToString() + ",[state]=2");
            updateFlowSql.Append(" where [id]=" + incharge.id.ToString());
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + UserConfig.UsersTableName + " set ");
            strSql.Append("[" + s_money + "]=[" + s_money + "]-" + incharge.money.ToString());
            strSql.Append(" where " + s_id + "=" + incharge.user_id.ToString());
            sqlList.Add(updateFlowSql.ToString());
            sqlList.Add(addInchargeFlowSql);
            sqlList.Add(strSql.ToString());
            string err = "";
            if (DbHelper.ExecuteSqlTran(sqlList, out err) > 0)
            {
                if (error == "")
                {
                    flag = true;
                }
                else
                {
                    SysManager.LogErrorWriteln(this.GetType(), "˻سֵ:" + err);
                }
            }
            else
            {
                StringBuilder sbSql = new StringBuilder();
                foreach (string s in sqlList)
                {
                    sbSql.Append("\r\n--Sql--\r\n" + s);
                }
                SysManager.LogErrorWriteln(this.GetType(), "˻سֵ->  ţ" + chargeNo + "   Ǯ" + incharge.money.ToString() + "\r\n" + sbSql.ToString());
            }
            return flag;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        private static IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetUDataList(int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(andWhere.ToString());
            StringBuilder strColNames = new StringBuilder();
            strColNames.Append("a.*,");
            strColNames.Append("b." + UserConfig.GetFieldName("username"));
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", strColNames.ToString(), "left join " + UserConfig.UsersTableName +
                " as b on a.user_id=b." + UserConfig.GetFieldName("id"));
            sql = SqlHelper.Join(sql, "as c", "c.*,d.name as payname", " left join " + Payonline.currTableName +
                " as d on c.payonline_id=d.id" + SqlHelper.GetJoinOrderBy(orderBy, "as c"));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

