using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;
using System.Data;
using PlugNT.Safe;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.App.Payment.Model;
namespace PlugNT.App.Payment.DAL
{
    public class Flow 
    {
        public static string currTableName = PayConfig.tabPrefix + "flow";
        private static IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        private static FlowInfo GetFlowInfo(IDataReader dr)
        {
            FlowInfo model = new FlowInfo();
            bool isRead = false;
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.no = dr["no"].ToString();
                    if (dr["user_id"].ToString() != "")
                    {
                        model.user_id = int.Parse(dr["user_id"].ToString());
                    }
                    if (dr["admin_id"].ToString() != "")
                    {
                        model.admin_id = int.Parse(dr["admin_id"].ToString());
                    }
                    if (dr["direction"].ToString() != "")
                    {
                        model.direction = int.Parse(dr["direction"].ToString());
                    }
                    if (dr["money_operate"].ToString() != "")
                    {
                        model.money_operate = double.Parse(dr["money_operate"].ToString());
                    }
                    if (dr["currency"].ToString() != "")
                    {
                        model.currency = int.Parse(dr["currency"].ToString());
                    }
                    model.remark = dr["remark"].ToString();
                    if (dr["create_time"].ToString() != "")
                    {
                        model.create_time = DateTime.Parse(dr["create_time"].ToString());
                    }
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        public static FlowInfo GetFlowInfo(int id)
        {
            IDataReader dr = GetReader(1, "*", " and id=" + id.ToString());
            return GetFlowInfo(dr);
        }
        public static FlowInfo GetFlowInfo(string no)
        {
            IDataReader dr = GetReader(1, "*", " and no=" + SqlHelper.FieldFilter(no));
            return GetFlowInfo(dr);
        }
        ///// <summary>
        ///// ûıȽnullΪ޼¼0Ϊȣ1Ϊ-1ΪС
        ///// </summary>
        ///// <param name="userId"></param>
        ///// <returns></returns>
        public static string GetAddSql(FlowInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " + currTableName + " (");
            strSql.Append("[no],user_id,admin_id,[direction],money_operate,[currency],[remark],create_time,[type])");
            strSql.Append(" values( ");
            strSql.Append(SqlHelper.FieldFilter(model.no) + ",");
            strSql.Append(model.user_id.ToString() + ",");
            strSql.Append(model.admin_id.ToString() + ",");
            strSql.Append(model.direction.ToString() + ",");
            strSql.Append(model.money_operate.ToString() + ",");
            strSql.Append(model.currency.ToString() + ",");
            strSql.Append(SqlHelper.FieldFilter(model.remark) + ",");
            strSql.Append("'" + model.create_time.ToString() + "',");
            strSql.Append(model.type.ToString());
            strSql.Append(")");
            return strSql.ToString();
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetUDataList(int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(andWhere.ToString());
            StringBuilder strColNames = new StringBuilder();
            strColNames.Append("a.*,");
            strColNames.Append("b." + UserConfig.GetFieldName("username") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("email"));
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", strColNames.ToString(), "left join " + UserConfig.UsersTableName +
                " as b on a.user_id=b." + UserConfig.GetFieldName("id") + SqlHelper.GetJoinOrderBy(orderBy, "as a"));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

