using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;
using System.Data;
using PlugNT.Safe;
using PlugNT.Cms.Custom;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.App.Payment.Model;
namespace PlugNT.App.Payment.BLL
{
    public class Flow
    {
        private readonly PlugNT.App.Payment.DAL.Flow dal = new PlugNT.App.Payment.DAL.Flow();
        public static string GetAddSql(FlowInfo model)
        {
            return PlugNT.App.Payment.DAL.Flow.GetAddSql(model);
        }
        /// <summary>
        /// ҳѯõDataTable(ǰ̨ҳ)
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="userId"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int userId, string orderBy, out int recordCount)
        {
            StringBuilder andwhere = new StringBuilder();
            if (userId > 0)
            {
                andwhere.Append(" and [user_id]=" + userId.ToString());
            }
            recordCount = dal.GetCount(andwhere.ToString());
            return dal.GetList(pageSize, currPageCount, recordCount, "*", andwhere.ToString(), orderBy);
        }
        /// <summary>
        /// ҳѯõDataTable(̨ҳ)
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="userId"></param>
        /// <param name="flowType"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetUDataList(int pageSize, int currPageCount, int userId, int flowType, string orderBy, out int recordCount)
        {
            StringBuilder andWhere = new StringBuilder();
            if (userId > 0)
            {
                andWhere.Append(" and [user_id]=" + userId.ToString());
            }
            if (flowType >= 0)
            {
                andWhere.Append(" and [type]=" + flowType.ToString());
            }
            return dal.GetUDataList(pageSize, currPageCount, andWhere.ToString(), orderBy, out recordCount);
        }
        public static FlowInfo GetFlowInfo(int id)
        {
            return PlugNT.App.Payment.DAL.Flow.GetFlowInfo(id);
        }
        public static FlowInfo GetFlowInfo(string no)
        {
            return PlugNT.App.Payment.DAL.Flow.GetFlowInfo(no);
        }
    }
}

