using System;
using System.Collections.Generic;
using System.Text;
using PlugNT.Common;
using PlugNT.Common.LitJson;
namespace PlugNT.App.OAuth
{
    public class taobao_helper
    {
        public taobao_helper()
        { }
        /// <summary>
        /// ȡAccess Token
        /// </summary>
        /// <param name="code">ʱAuthorization Code</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_access_token(string code)
        {
            OauthApiInfo config = OauthHelper.get_config("taobao");
            string send_url = "https://oauth.taobao.com/token";
            string param= "grant_type=authorization_code&code=" + code + "&client_id=" + config.oauth_app_id + "&client_secret=" + config.oauth_app_key + "&redirect_uri=" + Utils.UrlEncode(config.return_uri);
            string result = Utils.HttpPost(send_url, param);
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch
            {
                return null;
            }
        }
        /// <summary>
        /// ȡ¼ûԼϸϢ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <returns>JsonData</returns>
        public static JsonData get_info(string access_token, string fields)
        {
            string send_url = "https://eco.taobao.com/router/rest?access_token=" + access_token + "&method=taobao.user.buyer.get&format=json&v=2.0&fields=" + fields;
            string result = Utils.HttpGet(send_url);
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                JsonData jd = JsonMapper.ToObject(result);
                if (jd.Count > 0)
                {
                    return jd;
                }
            }
            catch
            {
                return null;
            }
            return null;
        }
    }
}

