using System;
using System.Collections.Generic;
using System.Text;
using PlugNT.Common;
using PlugNT.Common.LitJson;
namespace PlugNT.App.OAuth
{
    public class sina_helper
    {
        public sina_helper()
        { }
        /// <summary>
        /// ȡAccess Token
        /// </summary>
        /// <param name="code">ʱAuthorization Codeٷʾ10ӹ</param>
        /// <param name="state">ֹCSRFɹȨصʱԭ</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_access_token(string code)
        {
            try
            {
                OauthApiInfo config = OauthHelper.get_config("sina");
                string send_url = "https://api.weibo.com/oauth2/access_token";
                string param = "grant_type=authorization_code&code=" + code + "&client_id=" + config.oauth_app_id + "&client_secret=" + config.oauth_app_key + "&redirect_uri=" + Utils.UrlEncode(config.return_uri);
                string result = Utils.HttpPost(send_url, param);
                if (result.Contains("error"))
                {
                    return null;
                }
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(sina_helper), ex);
                return null;
            }
        }
        /// <summary>
        /// ѯûaccess_tokenȨϢ
        /// </summary>
        /// <param name="access_token">Access Token</param>
        /// <returns>Dictionary<T></returns>
        public static Dictionary<string, object> get_token_info(string access_token)
        {
            try
            {
                string send_url = "https://api.weibo.com/oauth2/get_token_info";
                string param = "access_token=" + access_token;
                string result = Utils.HttpPost(send_url, param);
                if (result.Contains("error"))
                {
                    return null;
                }
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(sina_helper), ex);
                return null;
            }
        }
        /// <summary>
        /// ȡ¼ûԼϸϢ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <param name="open_id">ûԣӢĶŷָ</param>
        /// <returns>JsonData</returns>
        public static JsonData get_info(string access_token, string open_id)
        {
            try
            {
                string send_url = "https://api.weibo.com/2/users/show.json?access_token=" + access_token + "&uid=" + open_id;
                string result = Utils.HttpGet(send_url);
                if (result.Contains("error"))
                {
                    return null;
                }
                JsonData jd = JsonMapper.ToObject(result);
                if (jd.Count > 0)
                {
                    return jd;
                }
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(sina_helper), ex);
                return null;
            }
            return null;
        }
    }
}

