using System;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;
using PlugNT.Common;
using PlugNT.Common.LitJson;
namespace PlugNT.App.OAuth
{
    public class renren_helper
    {
        public renren_helper()
        { }
        /// <summary>
        /// ȡʱAccess Token
        /// </summary>
        /// <param name="code">Authorization Code</param>
        /// <returns>JsonData</returns>
        public static JsonData get_access_token(string code)
        {
            OauthApiInfo config = OauthHelper.get_config("renren");
            string send_url = "https://graph.renren.com/oauth/token?grant_type=authorization_code&client_id=" + config.oauth_app_id + "&client_secret=" + config.oauth_app_key + "&code=" + code + "&redirect_uri=" + Utils.UrlEncode(config.return_uri);
            string result = Utils.HttpGet(send_url);
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                JsonData jd = JsonMapper.ToObject(result);
                if (jd.Count > 0)
                {
                    return jd;
                }
            }
            catch
            {
                return null;
            }
            return null;
        }
        /// <summary>
        /// ȡ¼ûԼϸϢ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <param name="open_id">ûopenid</param>
        /// <returns>Dictionary</returns>
        public static JsonData get_info(string access_token, string fields)
        {
            OauthApiInfo config = OauthHelper.get_config("renren");
            string send_url = "http://api.renren.com/restserver.do";
            StringBuilder param = new StringBuilder();
            param.Append("method=users.getInfo&");
            param.Append("access_token=" + access_token + "&");
            param.Append("fields=" + fields + "&");
            param.Append("format=json&");
            param.Append("v=1.0&");
            param.Append("sig=" + MD5Encrpt("access_token=" + access_token + "fields=" + fields + "format=jsonmethod=users.getInfov=1.0" + config.oauth_app_key));
            string result = Utils.HttpPost(send_url, param.ToString());
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                JsonData jd = JsonMapper.ToObject(result);
                if (jd.Count > 0)
                {
                    return jd;
                }
            }
            catch
            {
                return null;
            }
            return null;
        }
        /// <summary>
        /// MD5 
        /// </summary>
        /// <param name="plainText">Ҫַܵ</param>
        public static string MD5Encrpt(string plainText)
        {
            MD5 md5Hash = MD5.Create();
            byte[] data = md5Hash.ComputeHash(Encoding.UTF8.GetBytes(plainText));
            StringBuilder sbList = new StringBuilder();
            foreach (byte d in data)
            {
                sbList.Append(d.ToString("x2"));
            }
            return sbList.ToString();
        }
    }
}

