using System;
using System.Collections.Generic;
using System.Text;
using PlugNT.Common;
using PlugNT.Common.LitJson;
namespace PlugNT.App.OAuth
{
    /// <summary>
    /// QQ OAuthʱصURLһҪWWW.
    /// </summary>
    public class qq_helper
    {
        public qq_helper()
        { }
        /// <summary>
        /// ȡʱAccess Token
        /// </summary>
        /// <param name="code">ʱAuthorization Codeٷʾ10ӹ</param>
        /// <param name="state">ֹCSRFɹȨصʱԭ</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_access_token(string code, string state)
        {
            try
            {
                OauthApiInfo config = OauthHelper.get_config("qq");
                string send_url = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&client_id=" + config.oauth_app_id + "&client_secret=" + config.oauth_app_key + "&code=" + code + "&state=" + state + "&redirect_uri=" + Utils.UrlEncode(config.return_uri);
                string result = Utils.HttpGet(send_url);
                if (result.Contains("error"))
                {
                    return null;
                }
                string[] parm = result.Split('&');
                string access_token = parm[0].Split('=')[1];    
                string expires_in = parm[1].Split('=')[1];      
                Dictionary<string, object> dic = new Dictionary<string, object>();
                dic.Add("access_token", access_token);
                dic.Add("expires_in", expires_in);
                return dic;
            }
            catch(Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(qq_helper), ex);
                return null;
            }
        }
        /// <summary>
        /// ȡûopenid
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_open_id(string access_token)
        {
            try
            {
                string send_url = "https://graph.qq.com/oauth2.0/me?access_token=" + access_token;
                string result = Utils.HttpGet(send_url);
                if (result.Contains("error"))
                {
                    return null;
                }
                int str_start = result.IndexOf('(') + 1;
                int str_last = result.LastIndexOf(')') - 1;
                result = result.Substring(str_start, (str_last - str_start));
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(qq_helper), ex);
                return null;
            }
        }
        /// <summary>
        /// ȡ¼ûԼĻ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <param name="open_id">ûopenid</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_user_info(string access_token, string open_id)
        {
            try
            {
                OauthApiInfo config = OauthHelper.get_config("qq");
                string send_url = "https://graph.qq.com/user/get_user_info?access_token=" + access_token + "&oauth_consumer_key=" + config.oauth_app_id + "&openid=" + open_id;
                string result = Utils.HttpGet(send_url);
                if (result.Contains("error"))
                {
                    return null;
                }
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(qq_helper), ex);
                return null;
            }
        }
        /// <summary>
        /// ȡ¼ûԼϸϢ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <param name="open_id">ûopenid</param>
        /// <returns>Dictionary</returns>
        public static JsonData get_info(string access_token, string open_id)
        {
            try
            {
                OauthApiInfo config = OauthHelper.get_config("qq");
                string send_url = "https://graph.qq.com/user/get_info?access_token=" + access_token + "&oauth_consumer_key=" + config.oauth_app_id + "&openid=" + open_id;
                string result = Utils.HttpGet(send_url);
                if (result.Contains("error"))
                {
                    return null;
                }
                JsonData jd = JsonMapper.ToObject(result);
                if (jd.Count > 0)
                {
                    return jd;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                PlugNT.Cms.Custom.SysManager.LogErrorWriteln(typeof(qq_helper), ex);
                return null;
            }
        }
    }
}

