using System;
using System.Collections.Generic;
using System.Text;
using PlugNT.Common;
using PlugNT.Common.LitJson;
namespace PlugNT.App.OAuth
{
    public class feixin_helper
    {
        public feixin_helper()
        { }
        /// <summary>
        /// ȡAccess Token
        /// </summary>
        /// <param name="code">ʱAuthorization Code</param>
        /// <returns>Dictionary</returns>
        public static Dictionary<string, object> get_access_token(string code)
        {
            OauthApiInfo config = OauthHelper.get_config("feixin");
            string send_url = "https://i.feixin.10086.cn/oauth2/access_token?grant_type=authorization_code&code=" + code + "&client_id=" + config.oauth_app_id + "&client_secret=" + config.oauth_app_key + "&redirect_uri=" + Utils.UrlEncode(config.return_uri);
            string result = Utils.HttpGet(send_url);
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch
            {
                return null;
            }
        }
        /// <summary>
        /// ȡ¼ûԼϸϢ
        /// </summary>
        /// <param name="access_token">ʱAccess Token</param>
        /// <returns>JsonData</returns>
        public static Dictionary<string, object> get_info(string access_token)
        {
            string send_url = "https://i.feixin.10086.cn/api/user.json?access_token=" + access_token;
            string result = Utils.HttpGet(send_url);
            if (result.Contains("error"))
            {
                return null;
            }
            try
            {
                Dictionary<string, object> dic = JsonMapper.ToObject<Dictionary<string, object>>(result);
                return dic;
            }
            catch
            {
                return null;
            }
        }
    }
}

