using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using PlugNT.Common;
using PlugNT.Cms.Page;
using PlugNT.Cms.Custom;
using PlugNT.App.OAuth.Model;
namespace PlugNT.App.OAuth.Web
{
    public partial class SetOAuth : AdminPager
    {
        private string sid = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            string type = (Request.QueryString["t"] == null) ? "" : Request.QueryString["t"].Trim();
            sid = (Request.QueryString["id"] == null) ? "0" : Request.QueryString["id"].Trim();
            if (!IsPostBack)
            {
                switch (type)
                {
                    case "add":
                        btnUpdate.Text = "  ";
                        break;
                    case "edit":
                        btnUpdate.Text = " ޸ ";
                        txtKey.ReadOnly = true;
                        break;
                    case "delete":
                        Delete();
                        break;
                    default:
                        ShowMessager("ֶΰʧܣȷ·ڣ", Type_Message.Error);
                        break;
                }
                if (OauthConfig.assSetuped)
                {
                    BindData();
                    hidAction.Value = type;
                }
                else
                {
                    ShowMessager("δװữ½Ȱװʹã", Type_Message.Error);
                }
            }
        }
        private void BindData()
        {
            if (sid != "" && sid != "0")
            {
                OauthInfo info = new PlugNT.App.OAuth.BLL.Oauth().GetOauthInfo(int.Parse(sid));
                if (info != null)
                {
                    txtName.Text = info.title;
                    txtImgUrl.Text = info.img_url;
                    txtId.Text = info.app_id;
                    txtKey.Text = info.app_key;
                    txtRemark.Text = info.remark;
                    txtSortId.Text = info.sort_id.ToString();
                    rblEnable.SelectedValue = info.is_lock.ToString();
                    txtAppPath.Text = info.api_path;
                }
            }
        }
        private void Delete()
        {
            this.CheckReadOnly();
            if (new PlugNT.App.OAuth.BLL.Oauth().Delete(int.Parse(sid)))
            {
                Response.Redirect("./Manage.aspx");
            }
            else
            {
                ShowMessager("ɾʧܣ", Type_Message.Error);
            }
        }
        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            this.CheckReadOnly();
            OauthInfo info = new OauthInfo();
            info.title = txtName.Text.Trim();
            info.img_url = txtImgUrl.Text.Trim();
            info.app_id = txtId.Text.Trim();
            info.app_key = txtKey.Text.Trim();
            info.remark = txtRemark.Text.Trim();
            info.sort_id =int.Parse( txtSortId.Text.Trim());
            info.is_lock = int.Parse(rblEnable.SelectedValue);
            info.api_path = txtAppPath.Text.Trim();
            if (hidAction.Value == "add")
            {
                if (new PlugNT.App.OAuth.BLL.Oauth().Add(info))
                {
                    Response.Redirect("./Manage.aspx");
                }
                else
                {
                    ShowMessager("ʧܣ", Type_Message.Error);
                }
            }
            else
            {
                if (hidAction.Value == "edit")
                {
                    info.id = int.Parse(sid);
                    if (new PlugNT.App.OAuth.BLL.Oauth().Update(info))
                    {
                        Response.Redirect("./Manage.aspx");
                    }
                    else
                    {
                        ShowMessager("޸ʧܣ", Type_Message.Error);
                    }
                }
                else
                {
                    ShowMessager("޸ʧܣδ֪", Type_Message.Error);
                }
            }
        }
    }
}

