using System;
using System.Xml;
using System.Text;
using System.Web;
using PlugNT.Common;
using PlugNT.Cms.Custom;
using PlugNT.App.OAuth.BLL;
using PlugNT.App.OAuth.Model;
namespace PlugNT.App.OAuth
{
    public class OauthHelper
    {
        /// <summary>
        /// ȡOAuthϢ
        /// </summary>
        /// <param name="oauth_name"></param>
        public static OauthApiInfo get_config(string oauth_name)
        {
            OauthInfo model = new Oauth().GetOauthInfo(oauth_name);
            if (model != null)
            {
                OauthApiInfo config = new OauthApiInfo();
                config.oauth_name = model.api_path.Trim();
                config.oauth_app_id = model.app_id.Trim();
                config.oauth_app_key = model.app_key.Trim();
                config.return_uri = SiteConfig.SiteUrl + OauthConfig.oauthIndexPath + "/" + model.api_path + "/return_url.aspx";
                return config;
            }
            return null;
        }
    }
}

