using System;
using System.Data;
using System.Data.Common;
using System.Text;
using System.Collections.Generic;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.App.OAuth.Model;
namespace PlugNT.App.OAuth.DAL
{
    /// <summary>
    /// ƽ̨:ʵ
    /// </summary>
    [Serializable]
    public class Oauth
    {
        private static string currTableName = OauthConfig.tabPrefix+ "oauth";
        public Oauth() { }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Add(OauthInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([title],img_url,app_id,app_key,remark,sort_id,is_lock,api_path)");
            strSql.Append(" values (");
            strSql.Append("@title,@img_url,@app_id,@app_key,@remark,@sort_id,@is_lock,@api_path)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@img_url",model.img_url),
                 ParamHelper.MakeParam("@app_id",model.app_id),
                 ParamHelper.MakeParam("@app_key",model.app_key),
                 ParamHelper.MakeParam("@remark",model.remark),
                 ParamHelper.MakeParam("@sort_id",model.sort_id),
                 ParamHelper.MakeParam("@is_lock",model.is_lock),
                 ParamHelper.MakeParam("@api_path",model.api_path)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Update(OauthInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("[title]=@title,");
            strSql.Append("img_url=@img_url,");
            strSql.Append("app_id=@app_id,");
            strSql.Append("app_key=@app_key,");
            strSql.Append("remark=@remark,");
            strSql.Append("sort_id=@sort_id,");
            strSql.Append("is_lock=@is_lock,");
            strSql.Append("api_path=@api_path");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@img_url",model.img_url),
                 ParamHelper.MakeParam("@app_id",model.app_id),
                 ParamHelper.MakeParam("@app_key",model.app_key),
                 ParamHelper.MakeParam("@remark",model.remark),
                 ParamHelper.MakeParam("@sort_id",model.sort_id),
                 ParamHelper.MakeParam("@is_lock",model.is_lock),
                 ParamHelper.MakeParam("@api_path",model.api_path),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fields"></param> 
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Update(List<Model_Field> fields, string andWhere)
        {
            if (fields.Count <= 0)
            {
                return false;
            }
            StringBuilder sbField = new StringBuilder();
            foreach (Model_Field field in fields)
            {
                if (field.fieldType == Type_Field.integerType)
                {
                    sbField.Append("," + field.fieldName + "=" + (string.IsNullOrEmpty(field.fieldValue) ? "0" : field.fieldValue));
                }
                else
                {
                    sbField.Append("," + field.fieldName + "='" + field.fieldValue.Replace("'", "''") + "'");
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append(sbField.ToString().TrimStart(','));
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			ParamHelper.MakeParam("@id",id)
		};
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount == -1 ? "" : "top " + topCount) + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public OauthInfo GetOauthInfo(int id)
        {
            bool isRead = false;
            string[] strArr = new string[9];
            IDataReader dr = GetReader(1, "[id], [title], img_url, app_id, app_key, remark, sort_id, is_lock, api_path", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    strArr[0] = dr["id"].ToString();
                    strArr[1] = dr["title"].ToString();
                    strArr[2] = dr["img_url"].ToString();
                    strArr[3] = dr["app_id"].ToString();
                    strArr[4] = dr["app_key"].ToString();
                    strArr[5] = dr["remark"].ToString();
                    strArr[6] = dr["sort_id"].ToString();
                    strArr[7] = dr["is_lock"].ToString();
                    strArr[8] = dr["api_path"].ToString();
                }
                dr.Close();
            }
            if (isRead)
            {
                OauthInfo model = new OauthInfo();
                if (strArr[0] != "")
                {
                    model.id = int.Parse(strArr[0]);
                }
                model.title = strArr[1];
                model.img_url = strArr[2];
                model.app_id = strArr[3];
                model.app_key = strArr[4];
                model.remark = strArr[5];
                if (strArr[6] != "")
                {
                    model.sort_id = int.Parse(strArr[6]);
                }
                if (strArr[7] != "")
                {
                    model.is_lock = int.Parse(strArr[7]);
                }
                model.api_path = strArr[8];
                return model;
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// Requestȡģ(Request.FormҲRequest.QueryStringһ)
        /// </summary>
        /// <param name="requests"></param> 
        /// <returns></returns>
        public OauthInfo GetOauthInfo(System.Collections.Specialized.NameValueCollection requests)
        {
            OauthInfo model = null;
            if (requests != null)
            {
                model = new OauthInfo();
                if (requests["id"] != null)
                {
                    model.id = int.Parse(requests["id"]);
                }
                model.title = requests["title"];
                model.img_url = requests["img_url"];
                model.app_id = requests["app_id"];
                model.app_key = requests["app_key"];
                model.remark = requests["remark"];
                if (requests["sort_id"] != null)
                {
                    model.sort_id = int.Parse(requests["sort_id"]);
                }
                if (requests["is_lock"] != null)
                {
                    model.is_lock = int.Parse(requests["is_lock"]);
                }
                model.api_path = requests["api_path"];
            }
            return model;
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public string[] GetArray(string colNames, string andWhereOrderBy)
        {
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// õһеĶ
        /// </summary>
        /// <param name="colName"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public object GetSingle(string colName, string andWhereOrderBy)
        {
            return DbHelper.GetSingle("select top 1 [" + colName + "] from " + currTableName + " where 1=1 " + andWhereOrderBy);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Exists(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
		    ParamHelper.MakeParam("@id",id)
		};
            return DbHelper.Exists(strSql.ToString(), parameters);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Exists(string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where 1=1 " + andWhere);
            return DbHelper.Exists(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="appPath"></param> 
        /// <returns></returns>
        public OauthInfo GetOauthInfo(string appPath)
        {
            OauthInfo model = new OauthInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [title], img_url, app_id, app_key, remark, sort_id, is_lock, api_path", " and api_path=" + SqlHelper.FieldFilter(appPath));
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.title = dr["title"].ToString();
                    model.img_url = dr["img_url"].ToString();
                    model.app_id = dr["app_id"].ToString();
                    model.app_key = dr["app_key"].ToString();
                    model.remark = dr["remark"].ToString();
                    if (dr["sort_id"].ToString() != "")
                    {
                        model.sort_id = int.Parse(dr["sort_id"].ToString());
                    }
                    if (dr["is_lock"].ToString() != "")
                    {
                        model.is_lock = int.Parse(dr["is_lock"].ToString());
                    }
                    model.api_path = dr["api_path"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
    }
}

