using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using PlugNT.Common;
using PlugNT.Cms.Page;
using PlugNT.Cms.Custom;
namespace PlugNT.App.FileManager.Web.Admin.Pre_FileManager
{
    public partial class _Edit : AdminPager
    {
        protected string file = "";
        protected string backurl = "javascript:window.history.back();";
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            if (!IsPostBack && Request["file"] != null)
            {
                file = Request["file"].ToLower();
                if (Request["root"] != null)
                {
                    backurl = "./Default.aspx?nav=" + GetRequest("nav") + "&path=" + Request["root"].ToLower();
                }
                if (file.LastIndexOf('.') > 0 && SiteConfig.EditFileType.IndexOf(file.Substring(file.LastIndexOf('.')))>=0)
                {
                    try
                    {
                        TextBox_HTML.Text = Utils.ReadFile(Server.MapPath(file));
                    }
                    catch
                    {
                        TextBox_HTML.Text = Utils.ReadFile(file);
                    }
                    if (hidReferrer.Value.Trim() == "")
                    {
                        Uri uri = Request.UrlReferrer;
                        if (uri != null)
                        {
                            hidReferrer.Value = uri.ToString();
                        }
                    }
                }
                else
                {
                    Response.Redirect(file);
                }
            }
        }
        protected void imgBtnUpdate_Click(object sender, System.Web.UI.ImageClickEventArgs e)
        {
            if (Utils.CreateFile(Server.MapPath(Request["file"]), TextBox_HTML.Text))
            {
                object objFile=DataCache.GetCache(Request["file"].TrimStart('~'));
                if (objFile != null)
                {
                    DataCache.Remove(Request["file"].TrimStart('~'));
                }
                string refurl = hidReferrer.Value.Trim();
                string rawurl = Request.Url != null ? Request.Url.ToString() : Request.RawUrl;
                if (refurl != "" && refurl != rawurl)
                {
                    if (IsGotoMessager())
                    {
                        ShowMessager("ļ³ɹ", PlugNT.Cms.Custom.Type_Message.Ok);
                    }
                    else
                    {
                        Response.Redirect(refurl);  
                    }
                }
                else
                {
                    ShowMessager("ļ³ɹ", PlugNT.Cms.Custom.Type_Message.Ok);
                }
            }
            else
            {
                ShowMessager("ļʧܣ", PlugNT.Cms.Custom.Type_Message.Error);
            }
        }
    }
}

