package com.pingpang.websocketchat.send.impl;

import java.io.File;
import java.util.UUID;

import org.opencv.core.Mat;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import com.pingpang.image.ImageUtil;
import com.pingpang.websocketchat.Message;
import com.pingpang.websocketchat.send.ChatSend;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

/**
  * 图片特效
 * @author dell
 */
public class ChatSendAudioMagic extends ChatSend{

	@Override
	public void send(Message message, ChannelHandlerContext ctx) throws Exception {
		logger.info("image magic...");
		//data:image/jpeg;base64,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
		boolean save=false;
		if(null!=message.getMsg() && message.getMsg().startsWith("1")) {
			save=true;
			message.setMsg(message.getMsg().substring(1));
		}
		Mat image =ImageUtil.base642Mat(message.getMsg());
	    Mat check=ImageUtil.getFace(image);
	    String checkSucess=ImageUtil.Mat2Base64(check, ".png");
	    message.setMsg(checkSucess);
	    ctx.channel().writeAndFlush(new TextWebSocketFrame(this.getMapper().writeValueAsString(message)));
		
	    //保存图片
	    //String path="E:\\opencv4.4.0\\age-and-gender-classification\\img\\";
		if(save) {
			//path=path +message.getFrom().getUserCode();
			File saveImage=new File(PATH +message.getFrom().getUserCode());
			if(!saveImage.exists()) {
				saveImage.mkdirs();
			}
			ImageUtil.Mat2Img(image, ".jpeg",PATH +message.getFrom().getUserCode() +File.separator+ UUID.randomUUID()+".jpeg");
		    ImageUtil.initComPare(PATH +message.getFrom().getUserCode());
		}
	}
}
