package com.pingpang.service.impl;

import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.pingpang.service.GetServerMsg;
import com.pingpang.util.IPUtil;

@Service
@DubboService
public class GetServerMsgImpl implements GetServerMsg {

	@Value("${netty.ip}")
	private String nettyIP;
	
	@Value("${netty.port}")
	private String neetyPort;
	
	@Override
	public String getServerIPMsg() {
		if(null==nettyIP || "".equalsIgnoreCase(nettyIP.trim())) {
			nettyIP=IPUtil.getLocalHostExactAddress().getHostAddress();
		}
		return nettyIP+":"+neetyPort;
	}
}
