# Penzle NET delivery SDK

The Penzle .NET SDK provides a comprehensive set of documentation and resources to help you get started with the SDK and understand its various features and functionalities. Here are some of the key resources available:

## SDK integration recommendation for .NET applications

- [The recommendation procedure how to handle authentication and authorization.](./authentication-and-authorization/index.md)
- [The recommendation procedure how to use query builder and pagination.](./query-builder-and-pagination/index.md)
- [The recommended procedure for carrying out unit tests.](./unit-tests.md)
- [The recommendation how to handle errors using SDK.](./status-code-and-errors.md)
- [How to using SKD to manage entries.](./entries/index.md)
- [How to using SKD to manage forms.](./forms/index.md)
- [How to using SKD to manage assets.](./assets/index.md)
- [How to using SKD to manage templates.](./templates/index.md)

## Additional information

In order to find more developers material please visit next sections:

- [OAuth Flow for Authentication and Authorization.](https://github.com/Penzle/Penzle.Net/blob/main/docs/authenticated-access.md)
- [Increasing modularity through the use of dependency injection.](https://github.com/Penzle/Penzle.Net/blob/main/docs/configuration.md)
- [Utilize HttpClientFactory to improve the overall performance of your application as well as its stability.](https://github.com/Penzle/Penzle.Net/blob/main/docs/http-client-and-penzle-client.md)
- [Utilize models with strong typing to ensure that you get the most out of all of the benefits from string typeping models.](https://github.com/Penzle/Penzle.Net/blob/main/docs/models-with-strong-typing.md)
- [Make sure your keys are safe.](https://github.com/Penzle/Penzle.Net/blob/main/docs/azure-key-vault.md)
