# Ways to Contribute

We welcome and appreciate any contributions to this project! Here are some ways you can get involved:

## Report Bugs

If you find a bug in the code or documentation, you can help by submitting an issue to the project's GitHub repository. Be sure to include information about the browser and operating system you were using and steps to reproduce the problem.

## Suggest Enhancements

You can submit an issue to the project's GitHub repository if you have an idea for a new feature or improvement. Be sure to explain the problem you are trying to solve and how your proposed solution would work.

## Write Code

If you're comfortable with the codebase and have a bug fix or new feature in mind, you can submit a pull request to the project's GitHub repository. Follow the project's coding conventions and include tests for your new code.

### Changelog and conventional commits

We use [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/) to generate changelogs. Please follow the guidelines when contributing to this repository.

Here are a few examples of conventional commits:

- feat: Add new feature X to the application
- fix: Resolve bug causing crashing on launch
- docs: Update documentation for new feature Y
- style: Improve code formatting and readability
- refactor: Refactor code for better maintainability
- perf: Improve performance of feature Z
- test: Add new test cases for feature W
- chore: Update dependencies and remove unused files"
- revert: Revert changes made in previous commit
- build: Fix build errors and improve the build process"

Conventional commits follow the format <type>: <subject>. The type specifies what kind of change was made in the commit, while the subject describes the change itself. Additionally, the commit message should include a body explaining the change, as well as a footer containing any relevant information.
As an example, here is a conventional commit with the following format: **type**: **subject**:

**feat: Add new login feature to the application** 

The type of the commit is "feat", which stands for "feature", and the subject is "Add a user login feature to the application". Commit messages may also include a body with more details about the feature, such as the specific functionality implemented. In addition, it may include information such as the issue number or pull request.

Here is an example of a conventional commit with a scope in the format of **type(scope): subject**:

**fix(UserModule): Fix issue with user registration**

In this example, the type is "fix" which stands for "fix", the scope is "UserModule" which describes the part of the application that this commit is related to, and the subject is "Fix issue with user registration" which describes the change made in the commit. The commit message may also include a body that provides more details about the issue and how it was fixed, and a footer that includes any relevant information such as the issue number or pull request.

It is worth noting that scope is optional and it is not mandatory for all commits, it can be used to specify the part of the application that the commit is related to.

## Write Documentation

If you find the documentation lacking or unclear, you can help by submitting a pull request to the project's GitHub repository with improvements.

## Test the Project

You can help by testing the project and reporting any issues you find.

## Give Feedback

You can give feedback on the project's design, usability, or other aspects by submitting an issue to the project's GitHub repository.

## Spread the Word

You can help by spreading the word about the project to your friends, colleagues and on social media.

Thank you for your interest in contributing!

Please follow the project's Code of Conduct when participating in the community.