package de.ullisroboterseite.UrsAI2UDPv3;

import java.net.*;

public class UrsUdpXmitter {
    public static volatile String errMsg = ""; // Text der Fehlermeldung
    private static boolean useListenSocket = false; // true, wenn der Listenport aktiv ist und
                                                    // auf den gleichen Port wie LocalPort lauscht.
    static UrsAsyncFunctionEx<Object, Integer> XmitTask = new UrsAsyncFunctionEx<Object, Integer>() {
        @Override
        protected Integer execute(Object... p) {
            DatagramSocket so = (DatagramSocket) p[0]; // Socket für den Versand
            DatagramPacket dp = (DatagramPacket) p[1]; // zu versendendes Datagramm
            try {
                so.send(dp);
            } catch (Exception ex) {
                return 3;
            }
            return 0;
        }
    };

    static UrsAsyncFunctionEx<String, InetAddress> getIP = new UrsAsyncFunctionEx<String, InetAddress>() {
        @Override
        protected InetAddress execute(String... p) {
            try {
                return InetAddress.getByName((String) p[0]);
            } catch (Exception ex) {
                // return 3;
                return null;
            }
        }
    };

    private static int UpdXmit(DatagramSocket socket, DatagramPacket datagram) {
        errMsg = "";
        int rtc = XmitTask.doExecute(socket, datagram);
        if (rtc > 0)
            errMsg = "Can not send: " + XmitTask.getExeption().getCause().toString();
        return rtc;
    }

    private static DatagramSocket getXmitSocket(int LocalPort, DatagramSocket trySocket) {
        try {
            if (LocalPort <= 0) {
                return new DatagramSocket(); // beliebigen Port nutzen
            }

            if (trySocket == null) { // Wenn der Server nicht läuft
                return new DatagramSocket(LocalPort);
            }

            if (trySocket.getLocalPort() != LocalPort) {// wenn Sende- und Serverport nicht identisch sind
                return new DatagramSocket(LocalPort);
            }

            useListenSocket = true;
            return trySocket;

        } catch (Exception ex) {
            errMsg = "Inavlid 'LocalPort': " + LocalPort + ". Port in use?";
            return null;
        }
    }

    // Returncodes sind:
    // 0: erfolgreicher Versand
    // 1: IP-Adressangabe kann nicht in IPv4 umgewandelt werden
    // (s. JavaInetAddress.getByName)
    // 2: Unter LocalPort kann kein Socket angelegt werden
    // 3: Fehler beim Versenden
    public static int Xmit(String RemoteIP, int RemotePort, int LocalPort, byte[] data, DatagramSocket trySocket) {
        DatagramSocket ds = null;
        InetAddress toAddr;
        useListenSocket = false; // true, wenn der Listenport aktiv ist und
                                 // auf den gleichen Port wie LocalPort lauscht.

        errMsg = ""; // Alte Fehlermeldung löschen
        int rtc;

        // Remote-IP-Adresse einlesen
        // ------------------------------------------------
        toAddr = getIP.doExecute(RemoteIP);
        if (toAddr == null) {
            errMsg = "Invalid 'RemoteIP': " + RemoteIP;
            return 1;
        }
        // ------------------------------------------------

        // DatagramSocket bereitstellen
        // ------------------------------------------------
        ds = getXmitSocket(LocalPort, trySocket);
        if (ds == null)
            return 2;
        // DatagramSocket bereitstellen
        // ------------------------------------------------

        try { // Sicherstellen, dass das Socket wieder geschlossen wird

            // DatagramPacket bereitstellen & versenden
            // ------------------------------------------------
            DatagramPacket dp = new DatagramPacket(data, data.length, toAddr, RemotePort);
            if (useListenSocket)
                rtc = UrsUdpXmitter.UpdXmit(trySocket, dp);
            else
                rtc = UrsUdpXmitter.UpdXmit(ds, dp);
            if (rtc != 0)
                errMsg = UrsUdpXmitter.errMsg;
            // ------------------------------------------------
        } catch (Exception e) {
            // hier, wenn das Datagramm nicht erstellt werden konnte
            errMsg = "Inavlid 'RemotePort': " + RemotePort;
            rtc = 4;
        }

        if (!useListenSocket) {
            ds.close();
            ds = null;
        }

        return rtc;
    } // Xmit
}