package de.ullisroboterseite.UrsAI2UDPv3;

import java.net.*;

public class UrsUdpReceiver {
    private static UrsReceiverEventListener Parent = null;
    private static UrsUdpReceiverThread RcvTask = null;
    public volatile static DatagramSocket ListenSocket = null;

    private static class UrsUdpReceiverThread extends Thread {
        public DatagramSocket dtgrSocket = null;
        public volatile boolean stopRequest = false;
        public volatile boolean isRunning = false;
        public volatile boolean DropOwnBroadcast = false;
        public volatile InetAddress LocalHost;

        UrsUdpReceiverThread(DatagramSocket ds) {
            dtgrSocket = ds;
        }

        // Returncodes sind:
        // 0: erfolgreicher Start
        // 1: LocalPort konnte nicht angelegt werden
        public void Begin(InetAddress lh) {
            LocalHost = lh;
            isRunning = true;
            stopRequest = false;
            start();
        } // Begin

        public void StopTread() {
            stopRequest = true;
            dtgrSocket.close();
            while (isRunning) { // einfach nur warten
            }
        }

        boolean isLocalNicIP(InetAddress packetIP) {
            for (InetAddress ip : UrsUdpHelper.getNICList())
                if (ip.equals(packetIP))
                    return true;
            return false;
        }

        @Override
        public void run() {
            int errCode = 0;
            try {
                byte[] buf = new byte[2048];
                while (true) {
                    // receive request
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    dtgrSocket.receive(packet);
                    if (DropOwnBroadcast)
                        // NIC-Liste immer wieder neu abrufen, weil sich die Netzwerk-Verbindung
                        // geändert haben kann!
                        if (isLocalNicIP(packet.getAddress())) {
                            continue;
                        }
                    Parent.PacketReceived(packet); // nach oben melden
                } // while
            } catch (

            Exception ex) {
                if (!stopRequest) {
                    errCode = 1;
                    String Message = ex.getMessage();
                    try {
                        DatagramPacket dp = new DatagramPacket(Message.getBytes(), Message.length(),
                                InetAddress.getByName("0.0.0.0"), 0);
                        Parent.PacketReceived(dp);
                    } catch (Exception e) {
                        // Nichts zu tun
                    }

                }
            } finally {
                if (dtgrSocket != null) {
                    dtgrSocket.close();
                    dtgrSocket = null;
                }
                isRunning = false;
                Parent.ListenerThreadStopped(errCode);
            } // try

        } // run

    } // UrsUdpReceiverThread

    // ----------------------------------------------------------------------------------------------
    // ----------------------------------------------------------------------------------------------

    public static void addListener(UrsReceiverEventListener EventListener) {
        Parent = EventListener;
    }

    public static boolean IsRunning() {
        return (RcvTask != null);
    }

    public static void setDropOwnbroadcast(boolean value) {
        try {
            RcvTask.DropOwnBroadcast = value;
        } catch (Exception e) {
            // nichts zu tun
        }
    }

    // Erstellt den Listener-Thread und startet ihn
    // Falls in Listener-Thread aktiv ist, wird er vorher terminiert
    // Returncodes sind:
    // 0: erfolgreicher Start
    // 1: DatagramSocket konnte nicht angelegt werden
    public static int BeginListening(InetAddress LocalHost, int LocalPort, boolean DropOwnBroadcast) {
        if (RcvTask != null) {
            StopListening(); // bestehenden Thread beenden
        }
        try {
            // ListenSocket = new DatagramSocket(LocalPort, LocalHost);
            ListenSocket = new DatagramSocket(LocalPort);
            ListenSocket.setReuseAddress(true);

        } catch (Exception ex) {
            return 1;
        }

        // Parent.DebuggerLog("", "Listen-Socket IP: " +
        // ListenSocket.getLocalAddress().getHostAddress());

        RcvTask = new UrsUdpReceiverThread(ListenSocket);
        RcvTask.DropOwnBroadcast = DropOwnBroadcast;
        RcvTask.Begin(LocalHost);

        Parent.ServerStarted(ListenSocket.getLocalAddress().getHostAddress(), ListenSocket.getLocalPort());

        return 0;
    } // BeginListening

    public static void StopListening() {
        if (RcvTask == null)
            return;

        RcvTask.StopTread();
        RcvTask = null;

        if (ListenSocket != null) { // sicherheitshalber
            ListenSocket.close();
            ListenSocket = null;
        }
    }
    // Interface
} // UrsUdpReceiver