package de.ullisroboterseite.UrsAI2UDPv3;

import java.util.*;
import java.net.*;

public class UrsUdpHelper {

    // #region Ermittlung der Host-Adresse ========================
    private static UrsAsyncFunction<InetAddress> getLocalHostTask = new UrsAsyncFunction<InetAddress>() {
        @Override
        protected InetAddress execute() {
            DatagramSocket socket = null;
            InetAddress localHost = null;
            try {
                localHost = InetAddress.getByName("0.0.0.0");
                socket = new DatagramSocket();
                // IP-Adresse und Port sind eigentlich beliebig. Es darf nur keine
                // Spezial-Adresse sein.
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                localHost = socket.getLocalAddress();
                socket.close();
                socket = null;
            } catch (Exception e) {
                // nichts zu tun
            }
            return localHost;
        }
    };

    public static String getLocalHostString() {
        InetAddress localHost = getLocalHostTask.doExecute();
        if (localHost.isAnyLocalAddress())
            return "";
        else
            return localHost.getHostAddress();

    }

    public static InetAddress getLocalHost() {
        return getLocalHostTask.doExecute();
    }

    // #endregion

    // #regionErmittlung aller NICs ===============================
    static UrsAsyncFunction<List<InetAddress>> getNICs = new UrsAsyncFunction<List<InetAddress>>() {
        @Override
        protected List<InetAddress> execute() {
            ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    if (iface.isLoopback() || !iface.isUp()) // filters out 127.0.0.1 and inactive interfaces
                        continue;

                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress addr = addresses.nextElement();
                        if (addr instanceof Inet4Address) {
                            ipList.add(addr);
                        }
                    }
                }
            } catch (SocketException e) {
            }
            return ipList;
        }
    };

    public static List<InetAddress> getNICList() {
        return getNICs.doExecute();
    }

    public static List<String> getNICNames() {
        List<InetAddress> li = getNICs.doExecute();
        List<String> ls = new ArrayList<String>();
        for (InetAddress ip : li) {
            ls.add(ip.getHostAddress());
        }
        return ls;
    }
    // #endregion
}