package de.ullisroboterseite.UrsAI2UDPv3;

/**
 * \brief Klasse zum Ausführen asynchroner Funktionen
 */
public abstract class UrsAsyncFunctionEx<ParamsType, ReturnType> {
    private ReturnType result;

    private MyThread myThread;
    private volatile boolean threadIsRunning = false;
    private volatile boolean threadWasAborted = false;
    private volatile Exception ex = null;

    private ParamsType[] localParams;

    /**
     * \brief Führt die Methode \ref execute aus.
     *
     * @return
     */
    public ReturnType doExecute(ParamsType... params) {
        localParams = params;
        threadWasAborted = false;
        ex = null;
        myThread = new MyThread();
        threadIsRunning = true;
        myThread.start();
        while (threadIsRunning)
            ;
        if (threadWasAborted)
            throw new RuntimeException("Fehler beim Ausführen der Funktion. Siehe getCause()", ex);
        return result;
    }

    /**
     * \brief Gibt an, ob der Thread auf Grund eines Fehlers in \ref doInBackground
     * abgebrochen wurde.
     *
     * @return true, falls \ref doInBackground eine Exception geworfen hat. false,
     *         wenn der Thread normal beendet wurde.
     */
    public synchronized boolean wasAborted() {
        return threadWasAborted;
    }

    /**
     * \ brief Liefert die in \ref doInBackground aufgetretene Exception.
     *
     * @return Die in \ref doInBackground aufgetretene Exception oder null, falls
     *         <br>
     *         - der Thread noch nie gestartet wurde<br>
     *         - der Thread noch aktiv ist<br>
     *         - der Thread fehlerfrei beendet wurde.
     */
    public synchronized Exception getExeption() {
        return ex;
    }

    /**
     * \brief Die Arbeitsmethode
     *
     * @param params Die übergebenen Argumente
     * @return Der zurück zu liefernde Wert.
     */
    protected abstract ReturnType execute(ParamsType... params);

    private class MyThread extends Thread {
        @Override
        public void run() {
            try {
                result = execute(localParams);
            } catch (Exception e) {
                threadWasAborted = true;
                ex = e;
            } finally {
                threadIsRunning = false;
            }
        }
    }
}
