/*
*   Laser- a command line utility to assemble LC3 assembly code
*
*   Copyright Notice:
*
*       Copyright 2018, 2019 Zhiyuan Fan
*
*   License Notice:
*
*       Laser is free software: you can redistribute it and/or modify
*       it under the terms of the GNU General Public License as published by
*       the Free Software Foundation, either version 3 of the License, or
*       (at your option) any later version.
*
*       Laser is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*       GNU General Public License for more details.
*
*       You should have received a copy of the GNU General Public License
*       along with Laser.  If not, see <https://www.gnu.org/licenses/>.
*/

#define USES_FLAG
#include "laser.h"

const char *about = "Laser- a command line utility to assemble LC3 assembly code\n\n"

                    "Copyright Notice:\n\n"

                    "\tCopyright 2018, 2019 Zhiyuan Fan\n\n"

                    "License Notice:\n\n"

                    "\tLaser is free software: you can redistribute it and/or modify\n"
                    "\tit under the terms of the GNU General Public License as published by\n"
                    "\tthe Free Software Foundation, either version 3 of the License, or\n"
                    "\t(at your option) any later version.\n\n"

                    "\tLaser is distributed in the hope that it will be useful,\n"
                    "\tbut WITHOUT ANY WARRANTY; without even the implied warranty of\n"
                    "\tMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
                    "\tGNU General Public License for more details.\n\n"

                    "\tYou should have received a copy of the GNU General Public License\n"
                    "\talong with Laser.  If not, see <https://www.gnu.org/licenses/>.\n";

const char *version_num = "2.0.1";

const char *usage = "Laser- a command line utility to assemble LC3 assembly code\n\n"
                    "Usage:\n"
                    "\t'laser -v' to display version number\n"
                    "\t'laser -h' to display a more detailed help message\n"
                    "\t'laser -a <file>' to assemble a file\n"
                    "\t'laser -c <file>' to remove all files generated by 'laser -a <file>'\n";

const char *help = "Usage:\n"
                    "\t-v: 'laser -v' displays version number\n"
                    "\t-h: 'laser -h' displays this message again\n"
                    "\t-q: 'laser -q' suppresses all warning messages during assembly\n"
                    "\t-s: 'laser -s' suppresses all warnings and errors during assembly\n"
                    "\t-a: 'laser -a <file>' assembles the specified file\n"
                    "\t    'laser -a *.asm' assembles all assembly files in current directory\n"
                    "\t-p: 'laser -p <file1> <file2>' assembles the specified files as a project\n"
                    "\t    'laser -p *.asm' assembles all files in current directory as a project\n"
                    "\t-c: 'laser -c <file>' removes all files generated during assembly\n";

const char *flags[] = { "-v", "-h", "-q", "-s", "-a", "-c", "-l", "-p"};

int8_t checkflags (char *f)
{
    for (int8_t i = 0; i < 8; i++) {
        if (strcmp (f, flags[i]) == 0)
            return i;
    }

    return -1;
}

static int8_t CLEANMODE = 0;
static int8_t LOGENABLED = 0;
static int8_t PROJECTMODE = 0;
static int8_t ASSEMBLEMODE = 0;

int8_t isclean (void)
{
    return CLEANMODE;
}

int8_t islogging (void)
{
    return LOGENABLED;
}

int8_t isproject (void)
{
    return PROJECTMODE;
}

int8_t isassemble (void)
{
    return ASSEMBLEMODE;
}

void setassemble (void)
{
    ASSEMBLEMODE = 1;
}

void setclean (void)
{
    CLEANMODE = 1;
}

void setlog (void)
{
    LOGENABLED = 1;
}

void setproject (void)
{
    PROJECTMODE = 1;
}