## RocketQA

**This folder contains the codes and models for our RocketQA research papers.**

`Update` **DuReader<sub>retrieval</sub>** (March, 2022):  [''DuReader_retrieval: A Large-scale Chinese Benchmark for Passage Retrieval from Web Search Engine''](https://arxiv.org/pdf/2203.10232.pdf) was published. The baseline code: [`DuReader-Retrieval-Baseline/`](DuReader-Retrieval-Baseline/)

**RocketQA v2** (August, 2021):  [''RocketQAv2: A Joint Training Method for Dense Passage Retrieval and Passage Re-ranking''](https://aclanthology.org/2021.emnlp-main.224.pdf) was accepted by EMNLP 2021. Code: [`RocketQAv2_EMNLP2021/`](RocketQAv2_EMNLP2021/)

**PAIR** (May, 2021):  [''PAIR: Leveraging Passage-Centric Similarity Relation for Improving Dense Passage Retrieval''](https://aclanthology.org/2021.findings-acl.191.pdf) was accepted by ACL 2021 Findings. Code: [`PAIR_ACL2021/`](PAIR_ACL2021/)

**RocketQA v1** (March, 2021):  [''RocketQA: An Optimized Training Approach to Dense Passage Retrieval for Open-Domain Question Answering''](https://aclanthology.org/2021.naacl-main.466.pdf) was accpet by NAACL 2021. Code:  [`RocketQA_NAACL2021/`](RocketQA_NAACL2021/)

  
## Citations

If you find RocketQA v1 models helpful, feel free to cite the following publication:

```
@inproceedings{rocketqa_v1,
    title="RocketQA: An Optimized Training Approach to Dense Passage Retrieval for Open-Domain Question Answering",
    author="Yingqi Qu, Yuchen Ding, Jing Liu, Kai Liu, Ruiyang Ren, Wayne Xin Zhao, Daxiang Dong, Hua Wu and Haifeng Wang",
    year="2021",
    booktitle = "In Proceedings of NAACL"
}
```

If you find PAIR models helpful, feel free to cite the following publication:

```
@inproceedings{rocketqa_pair,
    title="PAIR: Leveraging Passage-Centric Similarity Relation for Improving Dense Passage Retrieval",
    author="Ruiyang Ren, Shangwen Lv, Yingqi Qu, Jing Liu, Wayne Xin Zhao, Qiaoqiao She, Hua Wu, Haifeng Wang and Ji-Rong Wen",
    year="2021",
    booktitle = "In Proceedings of ACL Findings"
}
```

If you find RocketQA v2 models helpful, feel free to cite the following publication:

```
@inproceedings{rocketqa_v2,
    title="RocketQAv2: A Joint Training Method for Dense Passage Retrieval and Passage Re-ranking",
    author="Ruiyang Ren, Yingqi Qu, Jing Liu, Wayne Xin Zhao, Qiaoqiao She, Hua Wu, Haifeng Wang and Ji-Rong Wen",
    year="2021",
    booktitle = "In Proceedings of EMNLP"
}
```

If you find DuReader<sub>retrieval</sub> dataset helpful, feel free to cite the following publication:

```
@inproceedings{DuReader_retrieval,
    title="DuReader_retrieval: A Large-scale Chinese Benchmark for Passage Retrieval from Web Search Engine",
    author="Yifu Qiu, Hongyu Li, Yingqi Qu, Ying Chen, Qiaoqiao She, Jing Liu, Hua Wu and Haifeng Wang",
    year="2022"
}
```

## License
This repository is provided under the [Apache-2.0 license](https://github.com/PaddlePaddle/RocketQA/blob/main/LICENSE).

