# Contributing Guidelines

<img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=for-the-badge" alt="PRs Welcome" /> <a href="https://github.com/PEC-CSS/Open-Source/pulls" target="_blank"><img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/PEC-CSS/Open-Source?style=for-the-badge" /></a> <a href="https://github.com/PEC-CSS/Open-Source/issues" target="_blank"><img alt="GitHub issues" src="https://img.shields.io/github/issues/PEC-CSS/Open-Source?style=for-the-badge" /></a> <a href="https://github.com/PEC-CSS/Open-Source/blob/master/README.md#contributors-" target="_blank"></a>


Ahoy there! Welcome to the __PEC-ACM Open Source__ Repository. We request you to read the __whole guidelines__ before making any pull requests. In case any doubt arises, please feel free to ask it in the Discussion tab.

</br>
Join <b>Official ACM PEC Open-Source Slack Channel</b> to be contribute to our Projects: 

<a href="https://join.slack.com/t/acmpecopen-source/shared_invite/zt-11mvk2veo-n_ZGh1e6fzhFIKrs57EXgg" target="_blank">https://join.slack.com/t/acmpecopen-source/shared_invite/zt-11mvk2veo-n_ZGh1e6fzhFIKrs57EXgg</a> 
</br>

## Resources for various CS fields
This repository also shares a collection of resources, contributed by the members of PEC ACM CSS as well as other tech enthusiasts of the college, for learning various fields of computer science. You can make use of these resources as a reference point for honing your technical skills.

</br>

| Resources | Link to the respective folder |
| ------------- | ------------- |
| Machine Learning | [ML](/ML) |
| Web Development | [Web Dev resources](/Web-Dev-resources) |
| App Development | [App Dev resources](/App-Dev-resources)|
| Competitive Coding & DSA | [CP DSA resources](/CP-DSA-resources) |
| Git and Github | [GIT](/GIT) |
| Open-Source | [Open-source](/Open-source) |
| Cyber Security | [Cyber Security](/Cyber-Security) |
| Blockchain Development | [Blockchain](/Blockchain) |
| Programming Languages | [Languages](/Languages) |
| PEC Courses | [PEC-Courses](/PEC-Courses) |
| Other Tech | [Other Tech resources](/Other-Tech-resources) |

</br>

You wish to further enrich this collection of resources?
Well go ahead and add your own as well 🤩! Here is how you can do this :
- Either fill up this [google form](https://forms.gle/Qn6T2omShiZW1LLR9) and your response will be updated by us in the repo
- OR send a PR after adding your response to the README file of the respective resource folder

</br>

## Contributing

### How to Contribute
There are several issues marked in the __Issues__ section. These include the questions with appropriate labels (if you are new to contributing we recommend you filter by good-first-issue label). Clicking on an open issue will show you the problem statement. Read that carefully and code what is asked for (sometimes the expected complexity of the solution may be marked).

__NOTE__ : If you are solving any Issue, make sure you create a new branch, mention the Issue ID in the title of your Pull request and adhere to the [Code of conduct and Coding style](https://github.com/PEC-CSS/Open-Source#for-contributors).

* If you are a complete beginner install the below resources:
	* You would first need to [install GIT](https://www.youtube.com/watch?v=2j7fD92g-gE)
	* We recommend you use VSCode for making changes. [Download Link](https://code.visualstudio.com/download) 

* Here's how you can create your first Pull Request(PR):
	* [Specific to our repository](https://drive.google.com/file/d/1QoXaWDvIwgksPrwogE2JHzcoZqa7MQib/view)
	* [Or a general detailed explanation](https://www.youtube.com/watch?v=LuL60r-XnL4)

<br/>

### For Contributors
It's our pleasure that you are considering contributing to this repository. We hope that this repository can be used by learners from PEC, or anywhere in the world. Being one of the contributors, you must adhere to the following __Code of Conduct__:
- Please make sure that the solution you are submitting has not already been added or a PR has already been raised. You should check that before submitting your PR.
- Check the label for the Issue you are solving, for example if it's good-first-issue then add your solution file in the Good-First-Issue folder and name the file appropiately or use the title itself (Print_Subsets_of_Array.cpp) 

#### Coding Style
- You can use any programming language you want.
- It is recommended that you use concepts of _Object Oriented Programming_ and _Functions_. Their names must be intuitive and should make their purpose clear to the readers.
- Use proper naming conventions for the language you are coding in. If you're not familiar with them, here are the conventions for [C++](http://micro-os-plus.github.io/develop/naming-conventions/) and [Python](https://pythonguides.com/python-naming-conventions).
- Make proper use of comments/docstrings wherever necessary but do not use them for stuff too trivial.
- If you are modifying documentation/comments, make sure your language is concise.
- You can also add the _algorithm explanation_ as a comment if you wish to.
- Use camelCase for variable and function names.
- And the most important thing: Have fun coding!
  
</br>
  
## Contributors:
### The Wonderful People Who Contributed Here
<table>
	<tr>
		<td>
			<a href="https://github.com/PEC-CSS/Open-Source/graphs/contributors">
  				<img src="https://contrib.rocks/image?repo=PEC-CSS/Open-Source" />
			</a>
		</td>
	</tr>
</table>
