# MedAlert

MedAlert is a simple Flutter application designed to help users manage their medications efficiently. With MedAlert, users can add medication information, set schedules, and receive notifications as reminders.

## Screenshots

![Screenshot 1](screenshots/1.png)
![Screenshot 2](screenshots/2.png)
![Screenshot 3](screenshots/3.png)
![Screenshot 4](screenshots/4.png)
![Screenshot 5](screenshots/5.png)
![Screenshot 6](screenshots/6.png)
![Screenshot 7](screenshots/7.png)

## Features

- **Medication Management**: Users can easily add and manage their medication information, including dosage, schedule, and any additional notes.
- **Weekly Activity**: The app provides users with a convenient weekly overview of their medication activity, allowing them to track their progress and adherence.
- **Notification Reminders**: MedAlert sends timely notifications to remind users to take their medications according to their specified schedules.

## Packages Used

- [Firebase Auth](https://pub.dev/packages/firebase_auth)
- [Firebase Firestore](https://pub.dev/packages/cloud_firestore)
- [Flutter Local Notification](https://pub.dev/packages/flutter_local_notifications)
- [Go Router](https://pub.dev/packages/go_router)
- [Dartz](https://pub.dev/packages/dartz)
- [Flutter Screen Utils](https://pub.dev/packages/flutter_screenutil)
- [Get It](https://pub.dev/packages/get_it)
- [BLoC](https://pub.dev/packages/flutter_bloc)
- [Equatable](https://pub.dev/packages/equatable)

## Installation

To run MedAlert locally, follow these steps:

1. Clone the repository:
   ```shell
   git clone https://github.com/OssHeikal/MedAlert.git

2. Navigate to the project directory:
   ```shell
   cd MedAlert
   
3. Install dependencies:
   ```shell
   flutter pub get
      
4. Run the app: 
   ```shell
   flutter run

## Contributing

Contributions to MedAlert are welcome! If you encounter any issues or have suggestions for improvement, please submit a bug report or a feature request via the issue tracker. You can also fork the repository, make your changes, and submit a pull request.

