﻿//**********************************************************************************
//* Copyright (C) 2007,2016 Hitachi Solutions,Ltd.
//**********************************************************************************

#region Apache License
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#endregion

//**********************************************************************************
//* クラス名        ：RcFxCmnFunction
//* クラス日本語名  ：FrameWork.RichClient層の共通クラス
//*
//* 作成者          ：生技 西野
//* 更新履歴        ：
//*
//*  日時        更新者            内容
//*  ----------  ----------------  -------------------------------------------------
//*  2010/11/20  西野 大介         新規作成
//*  2012/06/14  西野 大介         コントロール検索の再帰処理性能の集約＆効率化。
//*  2014/05/16  西野 大介         キャスト可否チェックのロジックを見直した。
//*  2017/09/12  西野 大介         UserControlの動的配置対応のためアクセス修飾子を変更。
//*  2018/01/31  西野 大介         ネストしたユーザ コントロールに対応（senderで親UCを確認する）
//**********************************************************************************

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;

using Touryo.Infrastructure.Framework.Exceptions;
using Touryo.Infrastructure.Framework.Util;
using Touryo.Infrastructure.Public.Util;

namespace Touryo.Infrastructure.Framework.RichClient.Util
{
    /// <summary>FrameWork.RichClient層の共通クラス</summary>
    public class RcFxCmnFunction
    {
        #region コントロール取得＆イベントハンドラ設定

        /// <summary>コントロール取得＆イベントハンドラ設定（下位互換）</summary>
        /// <param name="ctrl">コントロール</param>
        /// <param name="prefix">プレフィックス</param>
        /// <param name="eventHandler">イベント ハンドラ</param>
        /// <param name="controlHt">コントロールのディクショナリ</param>
        public static void GetCtrlAndSetClickEventHandler(Control ctrl, string prefix, object eventHandler, Dictionary<string, Control> controlHt)
        {
            #region チェック処理

            // コントロール指定が無い場合
            if (ctrl == null)
            {
                // 何もしないで戻る。
                return;
            }

            // プレフィックス指定が無い場合
            if (prefix == null || prefix == "")
            {
                // 何もしないで戻る。
                return;
            }

            #endregion

            #region コントロール取得＆イベントハンドラ設定

            // コントロールのNameチェック
            if (ctrl.Name == null)
            {
                // コントロールName無し
            }
            else
            {
                // コントロールName有り

                // コントロールのName長確認
                if (prefix.Length <= ctrl.Name.Length)
                {
                    // 指定のプレフィックス
                    if (prefix == ctrl.Name.Substring(0, prefix.Length))
                    {
                        // イベントハンドラを設定する。
                        if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_BUTTON))
                        {
                            // BUTTON
                            Button button = RcFxCmnFunction.CastByAsOperator<Button>(ctrl, prefix);

                            // ハンドラをキャストして設定
                            button.Click += (EventHandler)eventHandler;

                            // ディクショナリに格納
                            // ControlHt.Add(ctrl.Name, ctrl);
                            controlHt[ctrl.Name] = ctrl; // 2009/08/10-この行
                        }
                        else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_PICTURE_BOX))
                        {
                            // PICTURE BOX
                            PictureBox pictureBox = RcFxCmnFunction.CastByAsOperator<PictureBox>(ctrl, prefix);

                            // ハンドラをキャストして設定
                            pictureBox.Click += (EventHandler)eventHandler;

                            // ディクショナリに格納
                            // ControlHt.Add(ctrl.Name, ctrl);
                            controlHt[ctrl.Name] = ctrl; // 2009/08/10-この行
                        }
                        else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_COMBO_BOX))
                        {
                            // COMBO BOX
                            ComboBox comboBox = RcFxCmnFunction.CastByAsOperator<ComboBox>(ctrl, prefix);

                            // ハンドラをキャストして設定
                            comboBox.SelectedIndexChanged += (EventHandler)eventHandler;

                            // ディクショナリに格納
                            // ControlHt.Add(ctrl.Name, ctrl);
                            controlHt[ctrl.Name] = ctrl; // 2009/08/10-この行
                        }
                        else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_LIST_BOX))
                        {
                            // LIST BOX
                            ListBox listBox = RcFxCmnFunction.CastByAsOperator<ListBox>(ctrl, prefix);

                            // ハンドラをキャストして設定
                            listBox.SelectedIndexChanged += (EventHandler)eventHandler;

                            // ディクショナリに格納
                            // ControlHt.Add(ctrl.Name, ctrl);
                            controlHt[ctrl.Name] = ctrl; // 2009/08/10-この行
                        }
                        else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_RADIO_BUTTON))
                        {
                            // RADIO BUTTON
                            RadioButton radioButton = RcFxCmnFunction.CastByAsOperator<RadioButton>(ctrl, prefix);

                            // ハンドラをキャストして設定
                            radioButton.CheckedChanged += (EventHandler)eventHandler;

                            // ディクショナリに格納
                            // ControlHt.Add(ctrl.Name, ctrl);
                            controlHt[ctrl.Name] = ctrl; // 2009/08/10-この行
                        }
                    }
                }
            }

            #endregion

            #region 再起

            // 子コントロールがある場合、
            if (ctrl.Controls.Count != 0)
            {
                // 子コントロール毎に
                foreach (Control childCtrl in ctrl.Controls)
                {
                    // 再起する。
                    RcFxCmnFunction.GetCtrlAndSetClickEventHandler(childCtrl, prefix, eventHandler, controlHt);
                }
            }

            #endregion
        }

        /// <summary>コントロール取得＆イベントハンドラ設定</summary>
        /// <param name="ctrl">コントロール</param>
        /// <param name="prefixAndEvtHndHt">プレフィックスとイベント ハンドラのディクショナリ</param>
        /// <param name="controlHt">コントロールのディクショナリ</param>
        public static void GetCtrlAndSetClickEventHandler2(Control ctrl, Dictionary<string, object> prefixAndEvtHndHt, Dictionary<string, Control> controlHt)
        {
            // ループ
            foreach (string prefix in prefixAndEvtHndHt.Keys)
            {
                object eventHandler = prefixAndEvtHndHt[prefix];

                #region チェック処理

                // コントロール指定が無い場合
                if (ctrl == null)
                {
                    // 何もしないで戻る。
                    return;
                }

                // プレフィックス指定が無い場合
                if (prefix == null || prefix == "")
                {
                    // 何もしないで戻る。
                    return;
                }

                #endregion

                #region コントロール取得＆イベントハンドラ設定

                // コントロールのNameチェック
                if (ctrl.Name == null)
                {
                    // コントロールName無し
                }
                else
                {
                    // コントロールName有り

                    // コントロールのName長確認
                    if (prefix.Length <= ctrl.Name.Length)
                    {
                        // 指定のプレフィックス
                        if (prefix == ctrl.Name.Substring(0, prefix.Length))
                        {
                            // イベントハンドラを設定する。
                            if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_BUTTON))
                            {
                                // BUTTON
                                Button button = RcFxCmnFunction.CastByAsOperator<Button>(ctrl, prefix);

                                // ハンドラをキャストして設定
                                button.Click += (EventHandler)eventHandler;

                                // ディクショナリに格納
                                controlHt[ctrl.Name] = ctrl;
                                break;
                            }
                            else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_PICTURE_BOX))
                            {
                                // PICTURE BOX
                                PictureBox pictureBox = RcFxCmnFunction.CastByAsOperator<PictureBox>(ctrl, prefix);

                                // ハンドラをキャストして設定
                                pictureBox.Click += (EventHandler)eventHandler;

                                // ディクショナリに格納
                                controlHt[ctrl.Name] = ctrl;
                                break;
                            }
                            else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_COMBO_BOX))
                            {
                                // COMBO BOX
                                ComboBox comboBox = RcFxCmnFunction.CastByAsOperator<ComboBox>(ctrl, prefix);

                                // ハンドラをキャストして設定
                                comboBox.SelectedIndexChanged += (EventHandler)eventHandler;

                                // ディクショナリに格納
                                controlHt[ctrl.Name] = ctrl;
                                break;
                            }
                            else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_LIST_BOX))
                            {
                                // LIST BOX
                                ListBox listBox = RcFxCmnFunction.CastByAsOperator<ListBox>(ctrl, prefix);

                                // ハンドラをキャストして設定
                                listBox.SelectedIndexChanged += (EventHandler)eventHandler;

                                // ディクショナリに格納
                                controlHt[ctrl.Name] = ctrl;
                                break;
                            }
                            else if (prefix == GetConfigParameter.GetConfigValue(FxLiteral.PREFIX_OF_RADIO_BUTTON))
                            {
                                // RADIO BUTTON
                                RadioButton radioButton = RcFxCmnFunction.CastByAsOperator<RadioButton>(ctrl, prefix);

                                // ハンドラをキャストして設定
                                radioButton.CheckedChanged += (EventHandler)eventHandler;

                                // ディクショナリに格納
                                controlHt[ctrl.Name] = ctrl;
                                break;
                            }
                        }
                    }
                }

                #endregion
            }

            #region 再起

            // 子コントロールがある場合、
            if (ctrl.Controls.Count != 0)
            {
                // 子コントロール毎に
                foreach (Control childCtrl in ctrl.Controls)
                {
                    // 再起する。
                    RcFxCmnFunction.GetCtrlAndSetClickEventHandler2(childCtrl, prefixAndEvtHndHt, controlHt);
                }
            }

            #endregion
        }

        /// <summary>キャスト可否チェック</summary>
        /// <typeparam name="TResult">キャストする型</typeparam>
        /// <param name="target">Control</param>
        /// <param name="prefix">プレフィックス</param>
        /// <returns>キャスト結果</returns>
        public static TResult CastByAsOperator<TResult>(Control target, string prefix) where TResult : Control
        {
            // Cast By As Operator
            TResult result = target as TResult;

            if (result == null)
            {
                // キャストできない場合
                throw new FrameworkException(
                    FrameworkExceptionMessage.CONTROL_TYPE_ERROR[0],
                    String.Format(FrameworkExceptionMessage.CONTROL_TYPE_ERROR[1],
                    prefix, target.GetType().ToString()));
            }
            else
            {
                // キャストできた場合
                return result;
            }
        }

        #region コントロール取得 Util

        /// <summary>親UserControlを検索</summary>
        /// <param name="sender">object</param>
        /// <returns>親UserControl</returns>
        public static UserControl FindParentWinUserControl(object sender)
        {
            if ((sender as Control) != null)
            {
                Control ctrl = sender as Control;

                if ((ctrl as UserControl) != null)
                {
                    // UserControlを発見
                    return (UserControl)ctrl;
                }
                else if (ctrl.Parent != null)
                {
                    // 再帰（親を辿る
                    return RcFxCmnFunction.FindParentWinUserControl(ctrl.Parent);
                }
                else
                {
                    // ルートに到達
                    return null;
                }
            }
            else
            {
                // Controlでない。
                return null;
            }
        }

        #endregion

        #endregion

        /// <summary>
        /// デザイン・モードであるかチェックする。
        /// </summary>
        /// <returns>
        /// true:デザインモード時
        /// false:実行時時
        /// </returns>
        /// <remarks>
        /// DesignModeプロパティというデザイン・モードであるかチェックするものが用意されていますが、バグがあるため使用禁止です。
        /// </remarks>
        public static bool IsDesignMode()
        {
            // 開発環境のプロセス名を全て列挙する（VC++にもC++/CLIがあるので）。
            if (Process.GetCurrentProcess().ProcessName.ToLower() == "devenv"
                || Process.GetCurrentProcess().ProcessName.ToLower() == "vcexpress" 
                || Process.GetCurrentProcess().ProcessName.ToLower() == "vcsexpress"
                || Process.GetCurrentProcess().ProcessName.ToLower() == "vbexpress"
                || Process.GetCurrentProcess().ProcessName.ToLower() == "vwdexpress")
            {
                // デザインモード時
                return true;
            }
            else
            {
                // 実行時時
                return false;
            }
        }
        
    }
}
