# OpenKH Documentation - WinShell Extensions

In order to allow many quality of life improvements to aid in modding Kingdom Hearts games, OpenKH features several WinShell extensions to serve many different purposes.
These WinShell extensions negate the need to navigate through a tool for the most basic operations you can do with Kingdom Hearts files.

Currently, the extensions you see below are the extensions we have within the project:

- OpenKh.WinShell.IMDUtilities -> Provides thumbnail generation for IMD files and quick conversion of them to PNG.
- OpenKh.WinShell.IMZUtilities -> Provides ease of extraction and repack for IMZ files.

## Installation

All OpenKh.WinShell libraries are powered by SharpShell. So their installation is not standard, but is easy to do none-the-less. 
To install these extensions, download the SharpShell ServerManager from [this link](https://github.com/dwmkerr/sharpshell/releases).

Afterwards, open the ServerManager (you need Administrator Privileges for this). You will be greeted with this screen:

![ServerManager Main Screen](https://i.imgur.com/VpByIAO.png)

Click on "**File -> Load Server...**", and click on the WinShell extensions you want to load (In our case, **OpenKh.WinShell.IMDUtilities.dll** found in `bin/WinShell`)

Afterwards, you should see a screen like this:

![ServerManager with loaded DLLs](https://i.imgur.com/MkNKRfN.png)

And then, for every module you see on the list:

- Click on it and then click on "**Server -> Install**". If successful, you should see a popup telling you so.
- Click on "**Server -> Register Server (x64)**". No popup should appear.
- If successful, at the side of the window, you should see something like this where it says 64-Bit Server - Registered:

![ServerManager with installed DLLs](https://i.imgur.com/vtm04uL.png)

When you do all of the above, Click on "**Explorer -> Restart Explorer**" and that's it! The WinShell extensions should be successfully installed!
Note that you will only have to do this once. We hope you enjoy these extensions and Keep on Moddin'
