# OpenKH tools - Back to [Index](../index.md)

As a preface before tools are listed, it is important to note that different tools will be marked as either "CLI.ToolName" or "GUI.ToolName". This is to distinguish whether a specific program uses the command line or terminal or a GUI. The primary difference between the two is one involves typing commands into a terminal while the other has fancy clickable buttons.
If you have never used the command line before or have used it very little, fear not, for instructions for those tools will be equally as thorough as GUI instructions!

## General
[OpenKh.Tools.ModsManager](./GUI.ModsManager/index.md)

## Common formats

| File | Tool name
|------|-----------
|[TM2](../common/tm2.md) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)

## Kingdom Hearts II

| File | Tool name
|------|-----------
|[IDX](../kh2/file/type/idx.md) | [OpenKh.Command.IdxImg](./CLI.IdxImg/index.md)
|[IDX](../kh2/file/type/idx.md) | [OpenKh.Tools.IdxImg](./CLI.IdxImg/index.md)
|[msg/*](../kh2/file/type/msg.md) | OpenKh.Command.MsgTool
|[msg/*](../kh2/file/type/msg.md) | [OpenKh.Tools.Kh2TextEditor](./GUI.Kh2TextEditor/index.md)
|[AI](../kh2/file/type/ai.md) | [OpenKh.Command.Bdxio](./CLI.Bdxio/index.md)
|[BAR](../kh2/file/type/bar.md) | OpenKh.Tools.BarEditor
|[IMD](../kh2/file/type/image.md#imgd) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)
|[IMZ](../kh2/file/type/image.md#imgz) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)
|[FAC](../kh2/file/type/image.md#fac) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)
|[DPD](../kh2/file/type/dpd.md) | OpenKh.Tools.DpdViewer (incomplete)
|[2LD](../kh2/file/type/2ld.md#layout) | [OpenKh.Tools.LayoutEditor](./GUI.LayoutEditor/index.md)
|[2DD](../kh2/file/type/2ld.md#sequence) | [OpenKh.Tools.LayoutEditor](./GUI.LayoutEditor/index.md)
|[DOCT](../kh2/file/type/doct.md) | [OpenKh.Command.DoctChanger](./CLI.DoctChanger/index.md)
|[COCT](../kh2/file/type/coct.md) | [OpenKh.Command.CoctChanger](./CLI.CoctChanger/index.md)
|[MAP](../kh2/file/map.md) | [OpenKh.Command.MapGen](./CLI.MapGen/index.md)
|[ANB](../kh2/file/anb/anb.md) | [OpenKh.Command.AnbMaker](./CLI.AnbMaker/index.md)
|[00battle](../kh2/file/type/00battle.md) | OpenKh.Tools.LevelUpEditor
|[00objentry](../kh2/file/type/00objentry.md) | OpenKh.Tools.ObjentryEditor
|[00place](../kh2/file/type/place.md) | OpenKh.Tools.Kh2PlaceEditor
|[03system](../kh2/file/type/03system.md) | OpenKh.Tools.Kh2SystemEditor
|[msg/*/place.bin](../kh2/file/type/place.md) | OpenKh.Tools.Kh2PlaceEditor

| Tool | Purpose
|------|-----------
| [OpenKh.Tools.Kh2ObjectEditor](./GUI.Kh2ObjectEditor/index.md) | View and edit game Objects (Mdlx, Mset and Apdx files)

## Kingdom Hearts Birth By Sleep

| File | Tool name
|------|-----------
|[BBSAx.DAT](../bbs/bbsa.md)| OpenKh.Command.Bbsa
|[ARC](../bbs/arc.md) | OpenKh.Command.Arc
|[CTD](../bbs/ctd.md) | OpenKh.Tools.CtdEditor
|[event/](../bbs/events.md) | OpenKh.Tools.BbsEventTableEditor
|[font.arc](../bbs/events.md) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)
|[fonten.arc](../bbs/events.md) | [OpenKh.Tools.ImageViewer](./GUI.ImageViewer/index.md)

## Kingdom Hearts 1.5/2.5 ReMIX

| File | Tool name
|------|-----------
|[HD assets](../common/hdassets.md)| OpenKh.Command.HdAssets
