# [Kingdom Hearts Birth By Sleep](../index.md) - PMO files

The filename structure is as follows:

Category + ID + [World](worlds.md) + SubId

Eg: B00JB00 -> B 00 JB 00

### Category

| ID | Category |
| - | - |
| B | [Bosses](#Bosses) |
| F | [Field items](#Field-items) |
| G | [Interactables](#Interactables) (Not necessarily by the player) |
| H | [Characters](#Characters) |
| M | [Monsters](#Monsters) |
| N | [NPCs](#NPCs) |
| P | [Players](#Players) |
| W | [Weapons](#Weapons) |

### SubId

SubIds are used for different versions of a model (Eg: Eraqus normal and Eraqus with scars) or related models (Eg: Keyblades and Keychains)
In the model list SubIds are ignored to keep it small.

## PMO files

Notes:

* Models marked as (OG) use the original textures from vanilla.
* Models in parentheses are simple meshes without textures (At least visibly). Eg: (Plane)

### Bosses

| Filename | Description |
|-|-|
| B00JB | Twilight Thorn |
| B01CD | Symphony Master |
| B01DC | Pete (Dark) (Car) |
| B01EX | Misterious Figure |
| B01HE | Hades (Angry) |
| B01LS | Metamorphosis (White) |
| B01PP | Captain Hook |
| B01RG | Trinity Armor (Body) |
| B01SB | Maleficent |
| B01SW | Mad Treant |
| B01VS | Mimic Master |
| B02CD | Symphony Master - Trumpet |
| B02DC | Pete (Dark) |
| B02EX | Dark Hide |
| B02LS | Metamorphosis (White) |
| B02PP | Tick Tock the crocodile |
| B02RG | Trinity Armor (Arms) |
| B02SW | Mad Treant - Fruit |
| B02VS | Mimic Master - Torn Page (Unversed symbol) |
| B03CD | Symphony Master - Violin |
| B03DC | Pete (Justice) |
| B03RG | Trinity Armor (Lower Body) |
| B03SB | Maleficent (Dragon) |
| B03SW | Mad Treant - Rocket fruit |
| B03VS | Mimic Master - Torn Page (Terra) |
| B04CD | Symphony Master - Drum |
| B04RG | Trinity Armor (Left arm with blades) |
| B05CD | Symphony Master - Baton |
| B05RG | Trinity Armor (Lower body compact) |
| B06RG | Trinity Armor (Right arm) |
| B07RG | Trinity Armor (Left arm) |
| B08RG | Trinity Armor (Legs) |
| B10CD | Cursed Coach |
| B10DC | Chip |
| B10EX | Vanitas |
| B10HE | Ice Titan |
| B10LS | Gantu |
| B10SB | Wheel Master |
| B10SW | Magic Mirror |
| B10VS | Iron Imprisoner 1 |
| B11EX | Vanitas (Helmetless, Broken X-Blade) |
| B11HE | Ice Titan - Right foot |
| B11SB | Wheel Master - Arm |
| B11SW | Magic Mirror (Serious face) |
| B11VS | Iron Imprisoner 2 |
| B12EX | Vanitas Remnant |
| B12HE | Ice Titan - Left foot |
| B12SB | Wheel Master - Wheel |
| B12SW | Magic Mirror (Open mouth) |
| B12VS | Iron Imprisoner 3 |
| B13HE | Ice Titan - Right foot 2 |
| B13SW | Magic Mirror (Low quality) |
| B13VS | Iron Imprisoner 4 |
| B14HE | Ice Titan - Left foot 2 |
| B14VS | Iron Imprisoner - Cage |
| B20CD | Lucifer |
| B20DC | Dale |
| B20EX | Eraqus |
| B20HE | Hercules |
| B200LS | Experiment 221 |
| B20PP | Peter Pan |
| B20VS | Mad Treant (OG) |
| B21HE | Hercules 2 |
| B21LS | Experiment 221 - Body when dashing |
| B21VS | Mad Treant - Fruit (OG) |
| B22LS | Experiment 221 room robot arm |
| B22V | Mad Treant - Rocket fruit (OG) |
| B23LS | Experiment 221 room robot arm 2 |
| B30EX | Braig (Patch) |
| B30HE | Zack |
| B30VS | Symphony Master (OG) |
| B31EX | Braig - Projectile |
| B31VS | Symphony Master - Trumpet (OG) |
| B32EX | Braig |
| B32VS | Symphony Master - Violin (OG) |
| B33VS | Symphony Master - Drum (OG) |
| B34VS | Symphony Master - Baton (OG) |
| B40EX | Xehanort |
| B40HE | Zack (Helmetless) |
| B40VS | Cursed Coach (OG) |
| B41EX | The Gazing Eye / No Name |
| B41VS | Thornbite |
| B42EX | The Gazing Eye / No Name - Keychain |
| B50EX | Terranort / Terra - Xehanort |
| B50VS | Wheel Master (OG) |
| B51EX | Terranort / Terra - Xehanort (Slightly higher quality?) |
| B51VS | Wheel Master - Arm (OG) |
| B52EX | Terranort / Terra - Xehanort 2 |
| B52VS | Wheel Master - Wheel (OG) |
| B53EX | The Gazing Eye / No Name 2 |
| B54EX | The Gazing Eye / No Name - Keychain 2 |
| B55EX | Ends of the Earth - Morphed |
| B56EX | Dark Figure (Xehanort's Guardian) |
| B60EX | Ventus |
| B60VS | Zack 2 |
| B61EX | Wayward Wind |
| B61VS | Mirage Arena wall (Triangle down) |
| B62EX | Ventus (Armored) |
| B62VS | Mirage Arena wall (L) |
| B63EX | Vanitas (Ventus face, X-Blade) |
| B63VS | Mirage Arena wall (Triangle up) |
| B64EX | Ventus 2 |
| B64VS | Mirage Arena wall (L inverted) |
| B65EX | X-Blade |
| B65VS | Mirage Arena wall (Triangle down) 2 |
| B66VS | Mirage Arena wall (diamond) |
| B67VS | Mirage Arena wall (L) 2 |
| B68VS | Mirage Arena wall (Triangle up) 2 |
| B69EX | Ventus 3 |
| B70EX | Terra |
| B71EX | Ends of the Earth |
| B72EX | Terra (Armored) |
| B73EX | Terra 2 |
| B79EX | Terra 3 |
| B80EX | Aqua |
| B80VS | Hades (Angry) 2 |
| B81EX | Stormfall |
| B81VS | Armor of the Master (Eraqus armored) |
| B82EX | Aqua (Armored) |
| B82VS | No Heart (Xehanort armored) (Sleeves) |
| B83EX | Aqua 2 |
| B83VS | Monstro |
| B84VS | The Gazing Eye / No Name (Barrier, Textureless) |
| B85VS | No Heart (Xehanort armored) |
| B86VS | No Hearts's sleeve |
| B87VS | The Gazing Eye / No Name (Textureless) |
| B88VS | The Gazing Eye / No Name - Keychain (Textureless?) |
| B89EX | Aqua 3 |
| B90EX | Graveyard Keyblade 1 |
| B90VS | Ice Titan 2 |
| B91EX | Graveyard Keyblade 2 |
| B91VS | The Gazing Eye / No Name (Wings) |
| B92EX | Graveyard Keyblade 3 |
| B92VS | The Gazing Eye / No Name (Arm) |
| B93EX | Graveyard Keyblade 3 (Clean) |
| B93VS | The Gazing Eye / No Name (Leg) |
| B94EX | Graveyard Keyblade 4 (Clean) |
| B94VS | The Gazing Eye / No Name (Barrier) |
| B95EX | Graveyard Keyblade 5 |
| B96EX | Graveyard Keyblade 6 |
| B97EX | Graveyard Keyblade 7 |
| B98EX | Graveyard Keyblade 8 |
| B99EX | Graveyard Keyblade 9 |

### Field items

| Filename | Description |
|-|-|
| F01CD | Cinderella's crystal shoe |
| F01DC | Seasalt ice cream |
| F01DI | Papou fruit |
| F01DP | Ventus's wooden keyblade |
| F01HE | Coliseum entry |
| F01JB | KH 3D demo screen |
| F01KG | Keyblade Graveyard mountain |
| F01PP | Peter Pan's treasure chest |
| F01RG | Disney Town's passport |
| F01SB | Sleeping Beauty's spinning wheel (Textureless) |
| F01SW | Dwarf pickaxe |
| F01YT | Yen Sid's book |
| F02CD | Cinderella's carriage |
| F02DI | Destiny Islands's boat |
| F02DP | Wayfinders |
| F02EX | (Triangle) |
| F02KG | Keyblade Graveyard high mountain |
| F02LS | Stitch's Wayfinder |
| F02PP | Peter Pan's treasure map |
| F02SB | Thorn tree shadow |
| F02SW | Snow White's glass coffin |
| F02YT | Yen Sid's stains |
| F03CD | Cinderella's magical pumpkin |
| F03DP | Wooden sword |
| F03EX | Mickey's Star shard |
| F03HE | Zack's helmet |
| F03KG | Keyblade Graveyard mountain 2 |
| F03LS | Deep Space's Federation Ship |
| F03PP | Peter Pan's treasure map (Rolled) |
| F03RG | Door to Darkness |
| F03SB | Thorn tree shadow |
| F03SW | Snow White's flowers |
| F03YT | Star Seeker |
| F04CD | Cinderella's pink dress |
| F04DC | Ice cream cone |
| F04DI | Destiny Island's palm tree |
| F04DP | Land of Departure castle (Night) |
| F04EX | (Sphere) |
| F04HE | Greek vase |
| F04KG | Keyblade Graveyard mountain 3 |
| F04LS | Deep Space's police ship |
| F04RG | Chain (To tie Xehanort) |
| F04SW | Snow White's heart box |
| F04YT | Yen Sid's flood water |
| F05CD | Lucifer's cage |
| F05DI | Destiny Island's palm tree 2 |
| F05DP | Land of Departure's spiral hill |
| F05EX | (Unknown) |
| F05HE | Zack's sword |
| F05KG | Graveyard's keyblade stream |
| F05LS | Stitch's ship |
| F05PP | Spyglass |
| F05RG | Winnie the Pooh book |
| F05SW | Magic Mirror's glass |
| F06CD | Cinderella's chair |
| F06DI | Mount top |
| F06DP | Land of Departure's chains |
| F06HE | Sephiroth's feather |
| F06KG | Graveyard's keyblade |
| F06LS | Test flask |
| F06PP | Cannonball |
| F06RG | Kairi's flowers |
| F06SW | Snow White's apple |
| F07DP | Wayfinders |
| F07KG | Vanitas's helmet (Visor) |
| F07LS | Experiment 221's ball |
| F07PP | Neverland's boat |
| F07RG | Aqua's armor |
| F07SB | Phillip's sword |
| F07SW | Snow White's door |
| F08CD | Cinderella's horse |
| F08DP | Land of Departure chain |
| F08KG | Keyblade Graveyard's cross path |
| F08LS | Stitch's wayfinder (Broken) |
| F08PP | Tinker Bell's lamp |
| F08RG | Greek coin |
| F08SB | Phillip's cage's chain |
| F08SW | Magic Mirror's frame |
| F09DP | Vanitas's helmet |
| F09KG | Terra's armor |
| F09LS | Stitch's cage |
| F09PP | Hook's ship (Partial) |
| F09SB | Sleeping Beauty's bed |
| F09SW | Magic Mirror's frame 2 |
| F10CD | Yarn ball |
| F10DP | Land of Departure door |
| F10EX | Prize Box (Item) |
| F10LS | Experiment 221 room robot arm (Partial) |
| F10PP | Hook's hat |
| F10SB | Maleficent's castle labyrinth wall |
| F10SW | Broken Flask |
| F11CD | Yarn ball (Pink) |
| F11DC | Ice Cream (Rockin' Crunch) |
| F11DP | Master Defender |
| F11EX | Prize Box (Command) |
| F11KG | Graveyard rock |
| F11LS | Deep Space's jail ceiling |
| F11SB | Maleficent's castle labyrinth wall 2 |
| F12CD | Yarn Ball (Blue) |
| F12DC | Ice Cream (Royalberry) |
| F12DP | No Heart's chair |
| F12EX | Prize Box (Synthesis) |
| F12KG | Graveyard's ground |
| F12LS | Deep Space's elevator |
| F12SB | Maleficent's castle labyrinth wall 3 |
| F13CD | Cinderella's crystal shoe |
| F13DC | Ice Cream (Double Crunch) |
| F13DC | Prize Box (Ice cream ingredient) |
| F13KG | Kingdom Hearts (Blue) |
| F13LS | Deep Space cells |
| F13SB | Maleficent's castle tile |
| F14CD | Cinderella's dress (Mannequin) |
| F14DC | Ice Cream ball (Pink) |
| F14EX | D-Link prize |
| F14KG | Keyblade Graveyard clouds |
| F14SB | Sleeping Beauty's bed (Partial) |
| F14SW | Dwarf hat |
| F15CD | Pumpkin Patch |
| F15DC | Ice Cream ball (Brown) |
| F15KG | Graveyard's ground 2 |
| F16DC | Ice Cream ball (Green) |
| F16KG | Dive to the Heart - Ventus (Broken) |
| F17DC | Ice Cream (White) |
| F17KG | Dive to the Heart - Ventus (Broken 2) |
| F17LS | Stitch's romm wall |
| F18KG | Dive to the Heart - Ventus |
| F18LS | Blue Thing |
| F19KG | Chain skybox (Terranort fight) |
| F19LS | Stitch's glass container |
| F20EX | Dropped command (Attack) |
| F20KG | Dive to the Heart - Vanitas / Ventus |
| F21EX | Dropped command (Magic) |
| F21KG | Cilindrical cloud skybox |
| F22EX | Dropped command (Special) |
| F50CD | Necklace pearl |

### Interactables

| Filename | Description |
|-|-|
| G01CD | Chest (Small) (Castle of Dreams) |
| G01DC | Chest (Small) (Disney Town) |
| G01DI | Destiny Island palm tree 3 |
| G01DP | Chest (Small) (Land of Departure) |
| G01EX | (White circle) |
| G01HE | Chest (Small) (Olympus Coliseum) |
| G01JB | Chest (Small) (Jungle Book) |
| G01KG | Chest (Small) (Keyblade Graveyard) |
| G01LS | Chest (Small) (Deep Space) |
| G01PP | Chest (Small) (Neverland) |
| G01RG | Chest (Small) (Radiant Garden) |
| G01SB | Chest (Small) (Enchanted Dominion) |
| G01SW | Chest (Small) (Dwarf Woodlands) |
| G01VS | (Triangle) |
| G01WM | Land of Departure (World) |
| G01YT | Chest (Small) (Mysterious Tower) |
| G02CD | Chest (Large) (Castle of Dreams) |
| G02DC | Chest (Large) (Disney Town) |
| G02DI | Destiny Island palm tree 4 |
| G02DP | Chest (Large) (Land of Departure) |
| G02EX | (Triangle) |
| G02HE | Chest (Large) (Olympus Coliseum) |
| G02JB | Chest (Large) (Jungle Book) |
| G02KG | Chest (Large) (Keyblade Graveyard) |
| G02LS | Chest (Large) (Deep Space) |
| G02PP | Chest (Large) (Neverland) |
| G02RG | Chest (Large) (Radiant Garden) |
| G02SB | Chest (Large) (Enchanted Dominion) |
| G02SW | Chest (Large) (Dwarf Woodlands) |
| G02WM | Dwarf Woodlands (World) |
| G02YT | Chest (Large) (Mysterious Tower) |
| G03CD | Chest (Large, closed) (Castle of Dreams) |
| G03DC | Chest (Large, closed) (Disney Town) |
| G03DP | Chest (Large, closed) (Land of Departure) |
| G03EX | (Red pyramid) |
| G03HE | Chest (Large, closed) (Olympus Coliseum) |
| G03JB | Chest (Large, closed) (Jungle Book) |
| G03KG | Chest (Large, closed) (Keyblade Graveyard) |
| G03LS | Chest (Large, closed) (Deep Space) |
| G03PP | Chest (Large, closed) (Neverland) |
| G03RG | Chest (Large, closed) (Radiant Garden) |
| G03SB | Chest (Large, closed) (Enchanted Dominion) |
| G03SW | Chest (Large, closed) (Dwarf Woodlands) |
| G03WM | Castle of Dreams (World) |
| G03YT | Chest (Large, closed) (Mysterious Tower) |
| G04WM | Enchanted Dominion (World) |
| G05EX | (Red pyramid) |
| G05WM | Mysterious Tower (World) |
| G06WM | Radiant Garden (World) |
| G08WM | Olympus Coliseum (World) |
| G09WM | Deep Space (World) |
| G10BD | Board Tile lock |
| G10CD | Fork |
| G10DC | Disney Town's electricity meter |
| G10DI | Destiny Islands palm tree |
| G10EX | (Parallel planes) |
| G10HE | Greek vase |
| G10JB | (Ground texture) |
| G10KG | Graveyard tornado |
| G10LS | Deep Space box |
| G10PP | Neverland rock |
| G10RG | Winnie The Pooh book |
| G10SB | (Perpendicular planes) |
| G10SW | Wheel |
| G10VS | (Cube) |
| G10WM | (Unknown) |
| G11BD | Board Tile (Monochrome) |
| G11CD | Yarn ball (Red) |
| G11DC | Disney Town robot hand |
| G11DI | Destiny Islands palm tree |
| G11DP | Land of Departure fence |
| G11EX | (Parallel planes) |
| G11HE | Greek vase (Large) |
| G11JB | (Red pyramid) |
| G11KG | Graveyard cloud |
| G11LS | Deep Space box |
| G11PP | Neverland Rocks |
| G11SB | Maleficent's castle labyrinth wall |
| G11SW | Wheel |
| G11VS | (Pyramid) |
| G11WM | Neverland (World) |
| G12BD | Board Tile (Red) |
| G12CD | Match box |
| G12DC | Disney Town robot hand |
| G12DI | Destiny Islands palm tree |
| G12DP | Land of Departure training dummy |
| G12EX | (Parallel planes) |
| G12HE | Barrel |
| G12JB | (Stream) |
| G12KG | (Triangle) |
| G12LS | Gas container |
| G12PP | Rocks |
| G12RG | (Parallel planes) |
| G12SB | Wheel |
| G12SW | Dwarf box |
| G12VS | (Platform) |
| G12WM | Disney Town (World) |
| G13BD | Board Tile (Land of Departure) |
| G13CD | Cheese |
| G13DC | Disney Town robot hand |
| G13DI | Destiny Islands palm tree |
| G13DP | Land of Departure training dummy - Hit circle |
| G13EX | (Parallel planes) |
| G13HE | Explosive barrel |
| G13JB | (Stream) |
| G13KG | (Triangle) |
| G13LS | Deep Space console |
| G13PP | (Sphere) |
| G13RG | (Parallel planes) |
| G13SB | Gate |
| G13SW | Rail vehicle |
| G13WM | Keyblade Graveyard (World) |
| G14BD | Board Tile (Plane) |
| G14CD | Cheese |
| G14DC | Disney Town robot hand |
| G14DI | Destiny Islands palm tree |
| G14DP | Land of Departure training dummy - Hit circle |
| G14EX | (Square) |
| G14JB | (Stream) |
| G14LS | Platform |
| G14PP | Totem |
| G14RG | Square |
| G14SW | Flask |
| G15BD | Board Tile (Rolling boxes) |
| G15CD | White Lace |
| G15DC | Mickey shaped platform |
| G15DI | Destiny Islands palm tree |
| G15DP | (Parallel planes) |
| G15EX | (Perpendicular planes) |
| G15HE | (Parallel planes) |
| G15JB | Darkness area |
| G15LS | Elevator |
| G15PP | Jumping drum |
| G15RG | (Unknown) |
| G15SB | (Circle) |
| G15SW | Flask |
| G15VS | Mirage Arena prize box |
| G15WM | Mirage Arena (World) |
| G16BD | Board Tile (Golden) |
| G16CD | Button |
| G16DC | Pushing mechanism |
| G16DI | Destiny Islands palm tree |
| G16EX | (Plane) |
| G16JB | Darkness cage |
| G16LS | Gate |
| G16PP | Hook's ship (2D) |
| G16RG | (Plane) |
| G16SB | (Bipyramid) |
| G16SW | Chemical lab |
| G16VS | (Triangle) |
| G16WM | Keyblade Graveyard (World) (V1) |
| G17BD | Board Tile (Monochrome) |
| G17CD | Pink Fabric |
| G17DC | Pushing mechanism |
| G17DI | Destiny Islands palm tree |
| G17EX | (Perpendicular planes) |
| G17HE | (Plane) |
| G17JB | Column |
| G17LS | Ceiling thing |
| G17PP | Cannonball |
| G17RG | (Stuff) |
| G17SW | Chemical lab |
| G17VS | Pinball punch |
| G18BD | Board Tile (Bronze) |
| G18CD | White Sash |
| G18DC | Pushing mechanism |
| G18DI | Destiny Islands palm tree |
| G18EX | (Planes) |
| G18HE | (Plane) |
| G18JB | Column |
| G18LS | Box |
| G18PP | (Planes) |
| G18RG | (Wall) |
| G18SB | Breakable corner |
| G18SW | Dwarf box |
| G18VS | Yarn Ball (Red) |
| G19BD | Board tile (Golden star) |
| G19CD | Pink thread |
| G19DC | Gear platform |
| G19EX | (Planes) |
| G19JB | Walkable columns |
| G19LS | Box |
| G19PP | (Plane) |
| G19SB | Maleficent's castle archway |
| G19SW | Gate |
| G19VS | Platform |
| G20BD | Dice |
| G20CD | Spider web |
| G20DC | Gear platform |
| G20EX | (Plane) |
| G20JB | (Planes) |
| G20PP | (Planes) |
| G20SB | Maleficent's castle labyrinth wall |
| G20SW | Gate |
| G20VS | (Triangle) |
| G21CD | (Planes) |
| G21DC | Big rolling gear |
| G21EX | (Plane) |
| G21JB | (Plane) |
| G21LS | Column |
| G21PP | (Planes) |
| G21SB | Maleficent's castle labyrinth wall |
| G21SW | (Plane) |
| G22DC | Big rolling gear |
| G22EX | (Plane) |
| G22JB | (Plane) |
| G22LS | Box |
| G22SB | Arched window |
| G22SW | Gate |
| G22VS | Pinball part |
| G23CD | Cinderella (Dress) |
| G23DC | Pinball punch |
| G23JB | Darkness circles |
| G23LS | Box |
| G23SB | Wheel |
| G23SW | (Plane) |
| G23VS | Pinball part |
| G24CD | Prince Charming |
| G24DC | Pinball part |
| G24LS | Cell glass |
| G24PP | (Planes) |
| G24SB | Gate |
| G24SW | (Planes) |
| G24VS | (Plane) |
| G25CD | (Planes) |
| G25DC | Pinball bouncer (Pink) |
| G25LS | (Planes) |
| G25SW | (Planes) |
| G25VS | (Planes) |
| G26CD | (Plane) |
| G26DC | Pinball bouncer (Blue) |
| G26LS | Deep Space console |
| G26SW | Dark tree |
| G26VS | Pinball bouncer (Pink) |
| G27CD | (Planes) |
| G27DC | (Unknown) |
| G27LS | (Plane) |
| G28DC | Pinball part |
| G28VS | Monstro platform |
| G29DC | Pinball part |
| G29LS | Gate |
| G29SB | (Circle) |
| G29VS | Monstro platform |
| G30BD | (Box) |
| G30DC | Race slope |
| G30VS | Monstro mob |
| G31DC | Race boost |
| G31SB | Sleeping Beauty (Bed) |
| G31VS | Monstro mob |
| G32DC | Race tornado |
| G32SB | Thorns |
| G32VS | Monstro part |
| G33DC | (Triangle) |
| G33LS | (Plane) |
| G33SB | Gas Area |
| G33VS | Monstro part |
| G34DC | (Unknown) |
| G34LS | Deep Space console |
| G34VS | Monstro acid |
| G35DC | Fruitball machine |
| G35LS | (Triangle) |
| G35SB | Sleeping Beauty (Sleeping, partial) |
| G35VS | Monstro acid |
| G36LS | Boxes |
| G36VS | Monstro explosive barrel |
| G37DC | Ice Cream Beat machine |
| G39SB | (Planes) |
| G40SB | (Plane) |
| G40VS | Armor of the Master's ground |
| G41DC | Mailbox |
| G41SB | (Planes) |
| G41VS | Armor of the Master's ground - Shadow |
| G42DC | Fire hydrant |
| G42SB | (Planes) |
| G42VS | Monstro shape |
| G43DC | Popcorn stand |
| G43VS | Monstro water splash |
| G44DC | Lamp post |
| G44VS | Monstro water splash |
| G45DC | Fruitball goal |
| G45VS | Monstro water splash |
| G46VS | Monstro water splash |
| G47DC | Street pot |
| G48DC | Bench |
| G49DC | Fruitball watermelon |
| G50CD | Cinderella's dress stand |
| G50DC | Apple |
| G50DP | Cloth |
| G50HE | Closed sign |
| G50KG | Kingdom Hearts |
| G50LS | Gate |
| G50PP | Chest |
| G50RG | Gate |
| G50SB | Ground texture |
| G50SW | Snow White crystal coffin (Transparent) |
| G50VS | Circle structure |
| G51CD | Pink dress |
| G51DC | Fruitball banana |
| G51DP | Cloth |
| G51KG | Clouds |
| G51LS | Wall |
| G51RG | Broken gate |
| G51SB | Darkness semisphere |
| G51SW | Snow White's crystall coffin (Base) |
| G51VS | Circle structure |
| G51WM | (Circumference) |
| G52CD | Pumpkin patch |
| G52DC | Fruitball pineapple |
| G52DP | Block |
| G52EX | Yellow / Brown skybox |
| G52KG | Vanitas battle fragments |
| G52LS | Broken wall |
| G52RG | Merlin's house's umbrellas |
| G52SW | Circle |
| G52VS | Circle structure |
| G52WM | (Circumference) |
| G53CD | (Triangle) |
| G53DC | Fruitball grapes |
| G53DP | Door |
| G53KG | Dive to the Heart - Vanitas / Ventus |
| G53LS | (Plane) |
| G53SW | Dwarf house props |
| G53VS | Arena decoration |
| G53WM | (Circumference) |
| G54DC | Fruitball banana (Ground) |
| G54DP | Door |
| G54LS | (Broken wall) |
| G54SB | Square bush |
| G54WM | (Circumference) |
| G55DC | Fruitball grape (Ground) |
| G55DP | Broken column |
| G55LS | Robot arm |
| G55SB | Darkness semisphere |
| G55WM | (Circumference) |
| G56DC | Pinball part |
| G56DP | Stone bench |
| G56LS | Robot arm |
| G56WM | (Circumference) |
| G57LS | Purple plane |
| G58LS | Gate |
| G58SB | (Planes) |
| G58WM | (Circumference) |
| G59DC | Disney Town - Main Plaza |
| G59LS | Gate |
| G59SB | (Planes) |
| G59WM | (Circumference) |
| G60DC | Grass semisphere |
| G60LS | Blue triangle |
| G60VS | (Plane) |
| G60WM | (Circumference) |
| G61DC | Grass platform |
| G61LS | Prison cell |
| G61WM | (Circumference) |
| G62DC | Open gate |
| G62WM | (Circumference) |
| G63DC | Race pushing mechanisms |
| G63WM | (Circumference) |
| G65WM | (Circumference) |
| G70WM | (Line) |
| G71WM | (Line) |
| G72WM | (Line) |
| G73WM | (Line) |
| G74WM | (Line) |
| G75WM | (Line) |
| G76WM | (Line) |
| G77WM | (Line) |
| G78WM | (Line) |
| G79WM | (Line) |
| G80WM | (Line) |
| G81WM | (Line) |
| G82WM | (Line) |
| G83WM | (Line) |
| G84WM | (Sphere) |
| G85WM | (Sphere) |
| G86WM | (Sphere) |
| G87WM | (Sphere) |
| G88WM | (Sphere) |
| G89WM | (Sphere) |
| G90DC | Fruitball net |
| G90WM | (Sphere) |
| G91DC | Fruitball net |
| G92DC | Disney Town horn? |
| G93DC | Manhole cover |
| G94DC | Manhole cover |
| G95DC | Manhole cover |
| G99HE | Flask |

### Characters

| Filename | Description |
|-|-|
| H00JB | Sora (KH1) |
| H01CD | Cinderella (Casual) |
| H01DI | Sora (Kid) |
| H01DP | Eraqus |
| H01EX | Ventus |
| H01HE | Hercules |
| H01JB | Riku (KH1) |
| H01SW | Snow White |
| H01YT | Yen Sid |
| H02DI | Riku (Kid) |
| H02DP | Ventus (Before Land of Departure) |
| H02EX | Aqua |
| H02JB | Kairi (KH1) |
| H02YT | Donald (Castle) |
| H03DP | Mysterious Figure |
| H03EX | Terra |
| H03HE | Hades |
| H03JB | Mickey (KH2) |
| H03YT | Goofy (Castle) |
| H04DI | Xehanort (Black coat) |
| H04HE | Zack (Helmetless) |
| H04JB | Mickey (CoM) |
| H04PP | Captain Hook |
| H04SB | Maleficent |
| H04YT | Mickey (BBS) |
| H05CD | Fairy Godmother |
| H05DI | Ventus (Blanket) |
| H05KG | Ventus (Frozen, helmetless) |
| H05RG | Lea |
| H06DI | Riku (KH2) |
| H07RG | Kairi (Kid) |
| H09DI | Ansem SoD |
| H10DI | Xemnas |
| H10EX | Vanitas |
| H10RG | Ansem the Wise |
| H11EX | Ventus (Helmetless) |
| H11KG | Vanitas (Helmetless, broken X-Blade) |
| H11RG | Braig (Patch, bandaged, normal) |
| H12EX | Aqua (Helmetless) |
| H12RG | Xehanort (Apprentice Terranort) |
| H13EX | Terra (Helmetless) |
| H20PP | Peter Pan |
| H21EX | Ventus |
| H40EX | Xehanort |
| H41EX | Xehanort (Textureless) |
| H51EX | Xehanort (Terranort) |
| H63EX | Vanitas (Helmetless, Ventus, X-Blade) |

### Monsters

| Filename | Description |
|-|-|
| M00JB | Shadow |
| M01EX | Flood |
| M01LS | Wall gun |
| M01SB | Maleficent's Goon |
| M01SW | Enemy tree |
| M01VS | Flood (OG) |
| M02EX | Scrapper |
| M02SB | Maleficent's Goon (Bow) |
| M02SW | Doc (Box) |
| M02VS | Scrapper (OG) |
| M03DC | Bruiser (OG) |
| M03EX | Bruiser |
| M03SB | Builder |
| M03SW | Grumpy (Box) |
| M03VS | Bruiser (OG) |
| M04EX | Red Hot Chili |
| M04SW | Sleepy (Box) |
| M04VS | Red Hot Chili (OG) |
| M05EX | Monotrucker |
| M05SW | Bashful (Wagon) |
| M05VS | Monotrucker (OG) |
| M06EX | Thornbite |
| M06SW | Sneezy(Box) |
| M06VS | Thornbite (OG) |
| M07DC | Shoegazer (OG) |
| M07EX | Shoegazer |
| M07SW | Happy (Box) |
| M07VS | Shoegazer (OG) |
| M08CD | Prize Pod (OG) |
| M08DC | Prize Pod (OG) |
| M08EX | Spiderchest |
| M08HE | Prize Pod (OG) |
| M08LS | Prize Pod (OG) |
| M08PP | Prize Pod (OG) |
| M08RG | Prize Pod (OG) |
| M08SB | Prize Pod (OG) |
| M08SW | Prize Pod (OG) |
| M09CD | Prize Pod (OG) |
| M09DC | Prize Pod (OG) |
| M09EX | Archraven |
| M09HE | Prize Pod (OG) |
| M09LS | Prize Pod (OG) |
| M09PP | Prize Pod (OG) |
| M09RG | Prize Pod (OG) |
| M09SB | Prize Pod (OG) |
| M09SW | Prize Pod (OG) |
| M10EX | Hareraiser |
| M11CD | Thornbite (OG) |
| M11EX | Jellyshade |
| M12EX | Tank Toppler |
| M12VS | Tank Toppler (OG) |
| M13EX | Vile Phial |
| M13VS | Vile Phial (OG) |
| M14EX | Sonic Blaster |
| M15EX | Triple Wrecker |
| M16EX | Wild Bruiser |
| M16VS | Wild Bruiser (OG) |
| M17EX | Blue Sea Salt |
| M17VS | Blue Sea Salt (OG) |
| M18CD | Prize Pod (OG) |
| M18DC | Prize Pod (OG) |
| M18EX | Yellow Mustard |
| M18HE | Prize Pod (OG) |
| M18LS | Prize Pod (OG) |
| M18PP | Prize Pod (OG) |
| M18RG | Prize Pod (OG) |
| M18SB | Prize Pod (OG) |
| M18SW | Prize Pod (OG) |
| M18VS | Yellow Mustard (OG) |
| M19CD | Prize Pod (OG) |
| M19DC | Prize Pod (OG) |
| M19EX | Mandrake |
| M19HE | Prize Pod (OG) |
| M19LS | Prize Pod (OG) |
| M19PP | Prize Pod (OG) |
| M19RG | Prize Pod (OG) |
| M19SB | Prize Pod (OG) |
| M19SW | Prize Pod (OG) |
| M19VS | Mandrake (OG) |
| M20EX | Buckle Bruiser |
| M20VS | Buckle Bruiser (OG) |
| M21EX | Chrono Twister |
| M21VS | Chrono Twister (OG) |
| M22EX | Axe Flapper |
| M22VS | Axe Flapper (OG) |
| M23EX | Prize Pod |
| M23VS | Prize Pod (OG) |
| M24EX | Glidewinder |
| M25EX | Blobmob |
| M25VS | Blobmob (Textureless) |
| M26EX | Sphere bubble |
| M27EX | Buckle Bruiser - Buckle |
| M27VS | Buckle Bruiser (OG) - Buckle |
| M28CD | Prize Pod (OG) |
| M28DC | Prize Pod (OG) |
| M28EX | Buckle Bruiser - Buckle |
| M28HE | Prize Pod (OG) |
| M28LS | Prize Pod (OG) |
| M28PP | Prize Pod (OG) |
| M28RG | Prize Pod (OG) |
| M28SB | Prize Pod (OG) |
| M28SW | Prize Pod (OG) |
| M28VS | Buckle Bruiser (OG) - Buckle |
| M29CD | Prize Pod (OG) |
| M29DC | Prize Pod (OG) |
| M29EX | Chrono Twister - Sand |
| M29HE | Prize Pod (OG) |
| M29LS | Prize Pod (OG) |
| M29PP | Prize Pod (OG) |
| M29RG | Prize Pod (OG) |
| M29SB | Prize Pod (OG) |
| M29SW | Prize Pod (OG) |
| M29VS | Chrono Twister (OG) - Sand |
| M31EX | Jellyshade (OG) |
| M32EX | Jellyshade |
| M32VS | Jellyshade (OG) |
| M33EX | Jellyshade (OG) |
| M34EX | (Plane) |
| M38VS | Prize Pod (OG) |
| M39VS | Prize Pod (OG) |
| M40EX | Shadow |
| M41EX | Neoshadow |
| M42EX | Shadow Ball |
| M48VS | Prize Pod (OG) |
| M49VS | Prize Pod (OG) |
| M50EX | Vitality Vial |
| M51EX | Flame Box |
| M51VS | Maleficent's Goon |
| M52EX | Lone Runner |
| M52VS | Maleficent's Goon (Bow) |
| M53EX | Belly Balloon |
| M54EX | Floating Flora |
| M55EX | Ringer |
| M56EX | Gluttonous Goo |
| M57EX | Element Cluster |
| M58EX | Ringer |
| M58VS | Prize Pod (OG) |
| M59VS | Prize Pod (OG) |
| M90EX | Ventus |
| M91EX | Fake Aqua |
| M92EX | Terra |
| M93EX | Wayward Wind |
| M94EX | Rainfell |
| M95EX | Ends of the Earth |

### NPCs

| Filename | Description |
|-|-|
| N01BD | Fairy Godmother |
| N01CD | Cinderella (Casual) |
| N01DI | Sora (Kid) |
| N01EX | Flood (OG) |
| N01HE | Hercules |
| N01JB | Riku (KH1) |
| N01LS | Stitch |
| N01PP | Peter Pan |
| N01RG | Aeleus |
| N01SB | Aurora (Sleeping Beauty) |
| N01SW | Snow White |
| N01YT | Yen Sid |
| N02BD | Cinderella's carriage |
| N02CD | Cinderella (Dress) |
| N02DI | Riku (Kid) |
| N02DP | Ventus (Before Land of Departure) |
| N02HE | Phil |
| N02JB | Kairi (KH1) |
| N02LS | Dr. Jumba |
| N02PP | Tinkerbell |
| N02RG | Even |
| N02SB | Aurora (Sleeping Beauty) (Casual) |
| N02SW | Prince Florian (Casual) |
| N02YT | Donald (Castle) |
| N03BD | Cinderella's horse |
| N03CD | Cinderella (Ripped dress) |
| N03DI | Xehanort (Young) |
| N03HE | Hades (Angry) |
| N03PP | Lost Boy - Slightly |
| N03RG | Ienzo (Kid) |
| N03SB | Philip |
| N03SW | Evil Queen |
| N03YT | Goofy (Castle) |
| N04BD | Magic Pumpkin |
| N04CD | Prince Charming |
| N04DC | Minnie |
| N04DI | Xehanort (Black coat) |
| N04KG | Neoshadow |
| N04LS | Pleakley (Textureless) |
| N04PP | Lost Boy - Cubby |
| N04RG | Dilan |
| N04SW | Doc |
| N04YT | Mickey (BBS) |
| N05BD | Chip & Dale |
| N05CD | Fairy Godmother |
| N05DC | Daisy |
| N05DI | Ventus (Blanket) |
| N05KG | Ventus (Frozen, helmetless) |
| N05LS | Grand Councilwoman |
| N05PP | Smee |
| N05RG | Lea |
| N05SB | Flora |
| N05SW | Grumpy |
| N06BD | Rocket |
| N06CD | Lady Tremaine |
| N06DC | Chip & Dale |
| N06DI | Riku (KH2) (Textureless) |
| N06KG | Ventus (Frozen) |
| N06RG | Isa |
| N06SB | Fauna |
| N06SW | Happy |
| N07CD | Anastasia Tremaine |
| N07DC | Huey, Dewey & Louie |
| N07DI | Sora (Kid) |
| N07RG | Kairi (Kid) |
| N07SB | Merryweather |
| N07SW | Sleepy |
| N08CD | Drizella Tremaine |
| N08DC | Horace Horsecollar |
| N08DI | Riku (Kid) |
| N08RG | Kairi's grandmother |
| N08SB | Diablo (Maleficent's crow) |
| N08SW | Bashful |
| N09CD | Jaq |
| N09RG | Scrooge McDuck |
| N09SW | Sneezy |
| N10BD | Tinkerbell |
| N10CD | Lucifer |
| N10EX | Moogle Shop |
| N10RG | Ansem the Wise |
| N10SW | Dopey |
| N11CD | Grand Duke |
| N11EX | Moogle |
| N11JB | Dark Side |
| N11RG | Merlin |
| N11SW | Evil Queen (Witch) |
| N12BD | Hunny pot |
| N12CD | Cinderella (Casual) |
| N12EX | Moogle |
| N12SW | Magic Mirror |
| N13BD | Hunny pot |
| N13CD | Jaq (Key) |
| N13DC | Pete (Dark) |
| N13EX | Moogle |
| N13SW | Bird |
| N15DC | Huey (Race) |
| N16DC | Dewey (Race) |
| N17BD | Board die (Castle of Dreams) |
| N17DC | Louie (Race) |
| N18BD | Sphere (Textureless) |
| N19BD | Blue area |
| N20BD | Experiment 221 |
| N20DC | Pete (Justice) |
| N21BD | Rabbit |
| N21DC | Enchanted Broom |
| N22BD | Pumpkin |
| N22DC | Pluto |
| N23BD | Night Skybox |
| N23DC | Chip & Dale |
| N24BD | Board (100 Acre Wood) |
| N24DC | Huey (Race) |
| N25BD | Wayward Wind |
| N25DC | Dewey (Race) |
| N26BD | Rainfell |
| N26DC | Louie (Race) |
| N27BD | Earthshaker |
| N28BD | Experiment 221 (Dash body) |
| N29BD | (Triangle) |
| N30DC | Huey |
| N30HE | Zack |
| N45DC | Rocket |
| N46DC | Rocket |
| N47DC | Rocket |
| N48DC | Rocket |
| N49DC | Rocket |
| N50CD | (Cube) |
| N50DC | Rocket |

### Players

| Filename | Description |
|-|-|
| P00JB | Sora (KH1) |
| P01EX | Ventus |
| P02EX | Aqua |
| P03EX | Terra |
| P11EX | Ventus (Armored) |
| P12EX | Aqua (Armored) |
| P13EX | Terra (Armored) |
| P21EX | Ventus |
| P22EX | Aqua |
| P23EX | Terra |
| P31EX | Ventus (Armored) |
| P32EX | Aqua (Armored) |
| P33EX | Terra (Armored) |
| P41EX | Ventus (Helmetless) |
| P42EX | Aqua (Helmetless) |
| P43EX | Terra (Helmetless) |
| P93EX | Terra (Armored with cape) (2.5 exclusive) |

### Weapons

| Filename | Description |
|-|-|
| W01AQ | Waterfell |
| W01EX | Kingdom Key - Keychain (Textureless) |
| W01TE | Earthshaker |
| W01VE | Wayward Wind |
| W02AQ | Treasure Trove |
| W02EX | Treasure Trove - Keychain |
| W02TE | Treasure Trove |
| W02VE | Treasure Trove |
| W03AQ | Stroke of Midnight |
| W03EX | Stroke of Midnight - Keychain |
| W03TE | Stroke of Midnight |
| W03VE | Stroke of Midnight |
| W04AQ | Fairy Stars |
| W04EX | Fairy Stars - Keychain |
| W04TE | Fairy Stars |
| W04VE | Fairy Stars |
| W05AQ | Victory Line |
| W05EX | Victory Line - Keychain |
| W05TE | Victory Line |
| W05VE | Victory Line |
| W06AQ | Mark of a Hero |
| W06EX | Mark of a Hero - Keychain |
| W06TE | Mark of a Hero |
| W06VE | Mark of a Hero |
| W07AQ | Hyperdrive |
| W07EX | Hyperdrive - Keychain |
| W07TE | Hyperdrive |
| W07VE | Hyperdrive |
| W09AQ | Pixie Petal |
| W09EX | Pixie Petal - Keychain |
| W09TE | Pixie Petal |
| W09VE | Pixie Petal |
| W10AQ | Ultima Weapon |
| W10EX | Ultima Weapon - Keychain |
| W10TE | Ultima Weapon |
| W10VE | Ultima Weapon |
| W11AQ | Sweetstack |
| W11EX | Sweetstack - Keychain |
| W11TE | Sweetstack |
| W11VE | Sweetstack |
| W12AQ | Destiny's Embrace |
| W12TE | Darkgnaw |
| W12VE | Light Seeker (JP vanilla exclusive) |
| W13AQ | Stormfall |
| W13TE | Ends of the Earth |
| W14AQ | Brightcrest |
| W14TE | Chaos Ripper |
| W14VE | Frolic Flame |
| W15VE | Lost Memory |
| W16AQ | Void Gear |
| W16EX | Void Gear - Keychain |
| W16TE | Void Gear |
| W16VE | Void Gear |
| W17AQ | No Name |
| W17EX | No Name - Keychain |
| W17TE | No Name |
| W17VE | No Name |
| W18AQ | Royal Radiance |
| W18EX | Royal Radiance - Keychain |
| W18TE | Royal Radiance |
| W18VE | Royal Radiance |
| W19AQ | Master Defender |
| W20TE | Ends of the Earth (Morphed) |
| W30AQ | Rainfell (Morphed) |
| W30TE | Ends of the Earth (Morphed) |
| W30VE | Wayward Wind (Morphed) |
