using OpenKh.Imaging;
using System.Drawing;
using Xunit;

namespace OpenKh.Tests.Imaging
{
    public class ImageDecodeTests
    {
        public class Fake4bppImage : IImageRead
        {
            public Size Size => new Size(Width, Height);
            public PixelFormat PixelFormat => PixelFormat.Indexed4;
            public byte[] GetData() => Data4bpp;
            public byte[] GetClut() => Clut4bpp;
        }

        public const int Width = 16;
        public const int Height = 16;

        public static readonly byte[] Data4bpp = new byte[Width * Height / 2]
        {
            0x31, 0x33, 0x21, 0x33, 0x31, 0x23, 0x31, 0x33, 0x12, 0x13, 0x32, 0x22, 0x22, 0x33, 0x12, 0x13,
            0x31, 0x33, 0x21, 0x33, 0x31, 0x23, 0x31, 0x33, 0x33, 0x32, 0x13, 0x00, 0x03, 0x12, 0x33, 0x32,
            0x23, 0x21, 0x00, 0x33, 0x30, 0x01, 0x23, 0x21, 0x12, 0x13, 0x03, 0x44, 0x43, 0x03, 0x12, 0x13,
            0x32, 0x30, 0x34, 0x33, 0x34, 0x30, 0x32, 0x30, 0x32, 0x30, 0x34, 0x33, 0x34, 0x30, 0x32, 0x30,
            0x32, 0x30, 0x34, 0x33, 0x34, 0x30, 0x32, 0x30, 0x12, 0x13, 0x03, 0x44, 0x43, 0x03, 0x12, 0x13,
            0x23, 0x21, 0x00, 0x33, 0x30, 0x01, 0x23, 0x21, 0x33, 0x32, 0x13, 0x00, 0x03, 0x12, 0x33, 0x32,
            0x31, 0x33, 0x21, 0x33, 0x31, 0x23, 0x31, 0x33, 0x12, 0x13, 0x32, 0x22, 0x22, 0x33, 0x12, 0x13,
            0x31, 0x33, 0x21, 0x33, 0x31, 0x23, 0x31, 0x33, 0x33, 0x32, 0x13, 0x00, 0x03, 0x12, 0x33, 0x32
        };

        public static readonly byte[] Clut4bpp = new byte[]
        {
            0x38, 0xB4, 0x4A, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xB9, 0x25, 0x22, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x24, 0x9F, 0xDA, 0xFF
        };

        public static readonly byte[] ExpectedFrom4bpp = new byte[Width * Height * 4]
        {
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xDA, 0x9F, 0x24, 0xFF,
            0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x9F, 0x24, 0xFF, 0xDA, 0x9F, 0x24, 0xFF,
            0xDA, 0x9F, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0x22, 0x25, 0xB9, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xB4, 0x38, 0xFF, 0x4A, 0xB4, 0x38, 0xFF,
            0x4A, 0xB4, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0x22, 0x25, 0xB9, 0xFF,
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x25, 0xB9, 0xFF
        };

        [Fact]
        public void Decode4bppTest()
        {
            var actual = ImageDataHelpers.FromIndexed4ToBitmap32(Data4bpp, Clut4bpp, ImageDataHelpers.RGBA);
            Assert.Equal(ExpectedFrom4bpp, actual);
        }

        [Fact]
        public void DecodeImage4bppTest()
        {
            Assert.Equal(ExpectedFrom4bpp, new Fake4bppImage().ToBgra32());
        }
    }
}
