using System.Collections.Generic;

namespace OpenKh.Kh2
{
    public class MotionSet
    {
        public enum MotionName
        {
            IDLE,
            WALK,
            RUN,
            JUMP,
            FALL,
            LAND,
            LINK_IDLE,
            HANG,
            HANG_UP,
            ITEM,
            DAMAGE_S_FRONT_HIGH,
            DAMAGE_S_FRONT_LOW,
            DAMAGE_S_BACK_HIGH,
            DAMAGE_S_BACK_LOW,
            DAMAGE_AIR_FRONT,
            DAMAGE_AIR_BACK,
            DAMAGE_BLOW_FRONT,
            DAMAGE_BLOW_FRONT_LAND,
            DAMAGE_BLOW_BACK,
            DAMAGE_BLOW_BACK_LAND,
            DAMAGE_TORNADO_FRONT,
            DAMAGE_TORNADO_BACK,
            DAMAGE_TORNADO,
            DAMAGE_LARGE_FRONT,
            DAMAGE_LARGE_BACK,
            DAMAGE_RESERVE_3,
            DAMAGE_RESERVE_4,
            DAMAGE_RESERVE_5,
            DAMAGE_RESERVE_6,
            DAMAGE_RESERVE_7,
            DAMAGE_01,
            DAMAGE_02,
            DAMAGE_03,
            DAMAGE_04,
            DAMAGE_05,
            DAMAGE_06,
            DAMAGE_07,
            DAMAGE_08,
            DAMAGE_09,
            DAMAGE_10,
            DAMAGE_BLOW_RECOV,
            REFLECT,
            AUTOGUARD,
            REFLECT_AIR,
            APPEAR,
            LEAVE,
            LEAVE_AIR,
            FOOTWORK,
            TURN_L,
            TURN_R,
            TALK,
            TALK_END,
            CHANGEFORM,
            CHANGEEND,
            STUN_LOOP,
            STUN_END,
            MAGIC_FIRE,
            MAGIC_FIRE_FINISH,
            MAGIC_FIRE_AIR,
            MAGIC_BLIZZARD,
            MAGIC_BLIZZARD_FINISH,
            MAGIC_BLIZZARD_AIR,
            MAGIC_THUNDER,
            MAGIC_THUNDER_FINISH,
            MAGIC_THUNDER_AIR,
            MAGIC_CURE,
            MAGIC_CURE_FINISH,
            MAGIC_CURE_AIR,
            MAGIC_MAGNET,
            MAGIC_MAGNET_FINISH,
            MAGIC_MAGNET_AIR,
            MAGIC_REFLECT,
            MAGIC_REFLECT_FINISH,
            MAGIC_REFLECT_AIR,
            RTN_TURN,
            CALL_SUMMON_END,
            DEAD_LAND,
            DEAD_AIR,
            MEMO_IDLE,
            SUBMENU_IDLE,
            SUBMENU_ACTION1,
            SUBMENU_ACTION2,
            CALL_FRIEND,
            CALL_SUMMON,
            MENU_IDLE,
            REFLECT00,
            REFLECT01,
            REFLECT02,
            REFLECT03,
            REFLECT04,
            REFLECT05,
            REFLECT06,
            REFLECT07,
            REFLECT08,
            REFLECT09,
            REFLECT10,
            EX000,
            EX001,
            EX002,
            EX003,
            EX004,
            EX005,
            EX006,
            EX007,
            EX008,
            EX009,
            EX010,
            EX011,
            EX012,
            EX013,
            EX014,
            EX015,
            EX016,
            EX017,
            EX018,
            EX019,
            EX020,
            EX021,
            EX022,
            EX023,
            EX024,
            EX025,
            EX026,
            EX027,
            EX028,
            EX029,
            EX030,
            EX031,
            EX032,
            EX033,
            EX034,
            EX035,
            EX036,
            EX037,
            EX038,
            EX039,
            EX040,
            EX041,
            EX042,
            EX043,
            EX044,
            EX045,
            EX046,
            EX047,
            EX048,
            EX049,
            EX050,
            EX051,
            EX052,
            EX053,
            EX054,
            EX055,
            EX056,
            EX057,
            EX058,
            EX059,
            EX060,
            EX061,
            EX062,
            EX063,
            EX064,
            EX065,
            EX066,
            EX067,
            EX068,
            EX069,
            EX070,
            EX071,
            EX072,
            EX073,
            EX074,
            EX075,
            EX076,
            EX077,
            EX078,
            EX079,
            EX080,
            EX081,
            EX082,
            EX083,
            EX084,
            EX085,
            EX086,
            EX087,
            EX088,
            EX089,
            EX090,
            EX091,
            EX092,
            EX093,
            EX094,
            EX095,
            EX096,
            EX097,
            EX098,
            EX099,
            EX100,
            RTN_00,
            RTN_01,
            RTN_02,
            RTN_03,
            RTN_04,
            RTN_05,
            RTN_06,
            RTN_07,
            RTN_08,
            RTN_09,
        }
    
        public static int GetMotionSetIndex(
            IList<Bar.Entry> barEntries, MotionName motionId, bool isBattle, bool hasWeapon)
        {
            const int MaxMotionCountPerAnim = 4;
            var ModeTable = new byte[]
            {
                0x00, 0x01, 0x03, 0x02, 0x01, 0x00, 0x02, 0x03,
                0x02, 0x03, 0x01, 0x00, 0x03, 0x02, 0x00, 0x01
            };

            var modeIndex = isBattle == false ? 2 : 1;
            if (hasWeapon)
                modeIndex ^= 1;

            for (var i = 0; i < MaxMotionCountPerAnim; i++)
            {
                var msetId = ModeTable[modeIndex * 4 + i] + (int)motionId * 4;
                //if (msetId == 0)
                //    continue;
                if (ContainsAnimation(barEntries[msetId]))
                    return msetId;
            }

            return -1;
        }

        private static bool ContainsAnimation(Bar.Entry entry) =>
            entry.Stream.Length > 0;
    }
}
