using Microsoft.Xna.Framework.Graphics;
using OpenKh.Engine.Motion;
using OpenKh.Engine.Parsers;
using OpenKh.Bbs;
using OpenKh.Kh2;
using System.Collections.Generic;
using System.Linq;

namespace OpenKh.Engine.MonoGame
{
    public static class MeshLoader
    {
        public static VertexDeclaration PositionColoredTexturedVertexDeclaration =
            new VertexDeclaration(36, new VertexElement[]
            {
                new VertexElement(0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0),
                new VertexElement(12, VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 0),
                new VertexElement(20, VertexElementFormat.Vector4, VertexElementUsage.Color, 0),
            });

        public static IModelMotion FromKH2(Mdlx model) =>
            model != null ? new MdlxParser(model) : null;

        public static IModelMotion FromBBS(Pmo pmo) =>
            pmo != null ? new PmoParser(pmo, 100.0f) : null;

        public static IEnumerable<KingdomTexture> LoadTextures(
            this ModelTexture texture, GraphicsDevice graphics) => texture?.Images?
                .Select(texture => new KingdomTexture(texture, graphics)).ToArray() ??
                new KingdomTexture[0];
    }
}
