# Contributing to OpenKH

Welcome and thank you for your interest in contributing to OpenKH!

The project involves code and documentation. There is no need for you to have coding skills, as the documentation has a lot of room for improvements too!

## Ask questions

Your curiosity is the most important part when it comes to helping the project. If there is any aspect that you would like to help improve, feel free to ask about it and otherwise discuss it openly!

There are multiple ways to open a discussion. You can [open a new issue](https://github.com/OpenKH/OpenKh/issues/new) or [join our Discord server](https://discord.openkh.dev/). There is even a [Trello board](https://trello.com/b/xUMpsGBE/openkh) (currently unmaintained) showing an organized list of objectives that need to be worked on, have been completed, or are currently being worked on.

## Discord
An important detail to note with our [Discord server](https://discord.openkh.dev/) is the way it's set up requires you to be given a role before you can access 90% of the server. As soon as you join, you will be greeted with only three channels: #rules-and-info, #join-logs, and #introductions. We have had a lot of people who come and go because they see this and assume the server is dead. It's just hidden! Read the #rules-and-info channel! This is stated in there as plainly as possible, however some people presumably miss it anyway: if you agree to the terms of being a part of this community, you must either introduce yourself in the #introductions channel or grant yourself the @Seeker role in #join-logs!!! That will open up the server to allow you to see what all we've posted in other channels.

## Bug report

To report bugs and errors, [open a new issue](https://github.com/OpenKH/OpenKh/issues/new) and specify the steps taken to reproduce the bug, including the stack trace, messages, and the files that the tools or libraries were trying to open.

## Feature request

To request a feature, [open a new issue](https://github.com/OpenKH/OpenKh/issues/new) detailing your request. This can be anything from code or format optimizations to new features.

## Code guideline

[This](CODE_GUIDELINE.md) is a document that gives an idea of the code requirements to have your content merged into the master branch. For the most part, as long as the code works as intended and can be cleaned up later if needed, it's more than welcome! While C# is the primary language, other languages are welcome as long as they do not compromise the usability or readability of the toolchain or codebase!

## Documents contribution

Documentation is really important, as it is what everyone (including non-coders) can read and understand. It includes all technical research done for the games in the series, such as file formats, differences between various version of the game in question, unused content, how to use the libraries, tools, or modding tutorials, etc. RAM hacking content is more than welcome too.

In order to create proper documentation, it is recommended that you follow [these](DOCS_GUIDELINE.md) guidelines to make sure all documentation is easy to understand by anyone.
