﻿namespace Binarysharp.MSharp.Assembly.CallingConvention
{
    /// <summary>
    /// Define the 'This' Calling Convention, generated by Microsoft Visual C++ compiler.
    /// The first parameter must be a pointer of the instance of the class. Internally, the 'this' pointer is stored in ECX.
    /// </summary>
    /// <remarks>
    /// This calling convention is used for calling C++ non-static member functions.
    /// The first parameter must be a pointer of the instance of the class. That pointer is stored in the register ECX.
    /// The remaining parameter are pushed on the stack in the right-to-left order. The callee cleans the arguments from the stack.
    /// The return value is stored in the register EAX.
    /// </remarks>
    class MicrosoftThiscallCallingConvention : ICallingConvention
    {
        /// <summary>
        /// Formats a call to a function pointer.
        /// </summary>
        /// <param name="function">The function pointer.</param>
        /// <param name="parameters">The pointer of the parameters.</param>
        /// <param name="instructions">The list that receives the assembly instructions.</param>
        public void FormatCall(IntPtr function, IntPtr[] parameters, List<string> instructions)
        {
            // The 'this' pointer is stored in ECX
            instructions.Add("mov ecx, " + parameters[0]);

            // The parameters are pushed onto the stack in right-to-left order
            foreach (var parameter in parameters.Skip(1).Reverse())
            {
                instructions.Add("push " + parameter);
            }

            instructions.Add("call " + function);
        }
    }
}
