<p align="center">
  <!--
    Targeting https://openresource.dev/#gh-light-mode-only or https://openresource.dev/#gh-dark-mode-only is a hack to switch between the light and dark images.
    It'll trigger the corresponding GitHub CSS rule found out when trying the pure Markdown approach:
    - ![](https://github.com/user-attachments/assets/e7f5f8f0-3035-44cf-8928-69ac3d6a31fa#gh-dark-mode-only)
    - ![](https://github.com/user-attachments/assets/d54822bf-b12c-45d7-a627-a09bfa596344#gh-light-mode-only)
  -->
  <a href="https://openresource.dev/#gh-light-mode-only">
    <img src="https://github.com/user-attachments/assets/d54822bf-b12c-45d7-a627-a09bfa596344#gh-light-mode-only" alt="" style="max-width: 100%;"></a>
  </a>
  <a href="https://openresource.dev/#gh-dark-mode-only">
    <img src="https://github.com/user-attachments/assets/e7f5f8f0-3035-44cf-8928-69ac3d6a31fa#gh-dark-mode-only" alt="" style="max-width: 100%;"></a>
  </a>
</p>

<h1 align="center">openresource.dev</h1>

<p align="center">
  <b>Open {re}Source is your platform for sharing and discovering the open source world.</b>
  <br>
  Understand how it works, and learn how to create, manage, and contribute to open-source projects.
  <br>
  Join the open source community today and start making a difference.
</p>

<p align="center">
  <a href="https://openresource.dev">Open {re}Source website</a>
  ·
  <a href="https://discord.gg/fpUDwEMGwE">Discord</a>
</p>

## What's in This Repository

"openresource.dev" is the repository containing the code source deployed to https://openresource.dev.

## Status

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg)](CODE_OF_CONDUCT.md)
[![Integration Status](https://github.com/Open-reSource/openresource.dev/actions/workflows/integration.yml/badge.svg)](https://github.com/Open-reSource/openresource.dev/actions/workflows/integration.yml)

## Quick Start

All commands are run from the root of the project, from a terminal:

| Command                   | Action                                                                                           |
| :------------------------ | :----------------------------------------------------------------------------------------------- |
| `npm install`             | Installs dependencies                                                                            |
| `npm run dev`             | Run the development server at `localhost:4321`                                                   |
| `npm run build`           | Build your production site                                                                       |
| `npm run astro ...`       | Run CLI commands like `astro add`, `astro check`                                                 |
| `npm run astro -- --help` | Get help using the Astro CLI                                                                     |
| `npm run vercel`          | Run in the same conditions as Vercel                                                             |
| `npm run update:showcase` | Run the showcase script to gather links from https://github.com/orgs/Open-reSource/discussions/3 |
| `npm run test`            | Run the tests                                                                                    |
| `npm run prettier:read`   | Run Prettier to check the code style                                                             |
| `npm run prettier:write`  | Run Prettier to fix the code style                                                               |

## Bugs and Feature Requests

Have a bug or a feature request? Please first search for existing and closed issues. If your problem or idea is not addressed yet, [please open a new issue](https://github.com/Open-reSource/openresource.dev/issues/new/choose).

## Contributing

Please read through our [contributing guidelines](https://github.com/Open-reSource/openresource.dev/blob/main/CONTRIBUTING.md).

## Community

Get an update on Open {re}Source's development and chat with the project maintainers and community members:

- Follow [@open_resource on X](https://x.com/open_resource).
- Follow [@openresource on Mastodon](https://fosstodon.org/@openresource).
- Follow [@openresource.dev on Bluesky](https://bsky.app/profile/openresource.dev).
- Follow [@openresource on Threads](https://www.threads.net/@openresource).
- Follow [@open-re-source on LinkedIn](https://www.linkedin.com/company/open-re-source/).
- Explore [our GitHub Discussions](https://github.com/orgs/Open-reSource/discussions).
- Chat with the community and the maintainers on [our Discord channel](https://discord.com/invite/fpUDwEMGwE).
- Use [our RSS feed](https://openresource.dev/rss.xml) to know when articles are out!

## Copyright and License

Code released under the [MIT License](https://github.com/Open-reSource/openresource.dev/blob/main/LICENSE).

Content (including images) released under [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/):

- `public` directory
- `src/assets` directory
- `src/content` directory

## Thanks

[![Built with Astro](https://astro.badg.es/v2/built-with-astro/small.svg)](https://astro.build)

[![Built with Starlight](https://astro.badg.es/v2/built-with-starlight/small.svg)](https://starlight.astro.build)

## Sponsors

<p align="center">
  <a href="https://github.com/sponsors/Open-reSource" aria-label="Go to Open {re}Source's GitHub Sponsors page">
    <img src='https://cdn.jsdelivr.net/gh/Open-reSource/sponsors/sponsors.svg'/>
  </a>
</p>
